/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    public ServletContextResourcePatternResolver(ServletContext servletContext) {
        super(new ServletContextResourceLoader(servletContext));
    }

    public ServletContextResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    @Override
    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        if (rootDirResource instanceof ServletContextResource) {
            ServletContextResource scResource = (ServletContextResource)rootDirResource;
            ServletContext sc = scResource.getServletContext();
            String fullPattern = String.valueOf(scResource.getPath()) + subPattern;
            LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(8);
            this.doRetrieveMatchingServletContextResources(sc, fullPattern, scResource.getPath(), result);
            return result;
        }
        return super.doFindPathMatchingFileResources(rootDirResource, subPattern);
    }

    protected void doRetrieveMatchingServletContextResources(ServletContext servletContext, String fullPattern, String dir, Set<Resource> result) throws IOException {
        Set candidates = servletContext.getResourcePaths(dir);
        if (candidates != null) {
            boolean dirDepthNotFixed = fullPattern.contains("**");
            for (String currPath : candidates) {
                int dirIndex;
                if (!currPath.startsWith(dir) && (dirIndex = currPath.indexOf(dir)) != -1) {
                    currPath = currPath.substring(dirIndex);
                }
                if (currPath.endsWith("/") && (dirDepthNotFixed || StringUtils.countOccurrencesOf(currPath, "/") <= StringUtils.countOccurrencesOf(fullPattern, "/"))) {
                    this.doRetrieveMatchingServletContextResources(servletContext, fullPattern, currPath, result);
                }
                if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
                result.add(new ServletContextResource(servletContext, currPath));
            }
        }
    }
}

