/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runners.model.Statement;
import org.springframework.util.ClassUtils;

public class SpringRepeat
extends Statement {
    protected static final Log logger = LogFactory.getLog(SpringRepeat.class);
    private final Statement next;
    private final Method testMethod;
    private final int repeat;

    public SpringRepeat(Statement next, Method testMethod, int repeat) {
        this.next = next;
        this.testMethod = testMethod;
        this.repeat = Math.max(1, repeat);
    }

    public void evaluate() throws Throwable {
        int i = 0;
        while (i < this.repeat) {
            if (this.repeat > 1 && logger.isInfoEnabled()) {
                logger.info(String.format("Repetition %d of test %s#%s()", i + 1, ClassUtils.getShortName(this.testMethod.getDeclaringClass()), this.testMethod.getName()));
            }
            this.next.evaluate();
            ++i;
        }
    }
}

