/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public class MethodInvokingJobDetailFactoryBean
extends ArgumentConvertingMethodInvoker
implements FactoryBean,
BeanNameAware,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean {
    private static final Constructor oldJobExecutionExceptionConstructor = ClassUtils.getConstructorIfAvailable(class$org$quartz$JobExecutionException == null ? (class$org$quartz$JobExecutionException = MethodInvokingJobDetailFactoryBean.class$("org.quartz.JobExecutionException")) : class$org$quartz$JobExecutionException, class$java$lang$String == null ? (class$java$lang$String = MethodInvokingJobDetailFactoryBean.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Exception == null ? (class$java$lang$Exception = MethodInvokingJobDetailFactoryBean.class$("java.lang.Exception")) : class$java$lang$Exception, Boolean.TYPE);
    private String name;
    private String group = "DEFAULT";
    private boolean concurrent = true;
    private String targetBeanName;
    private String[] jobListenerNames;
    private String beanName;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private BeanFactory beanFactory;
    private JobDetail jobDetail;
    static /* synthetic */ Class class$org$quartz$JobExecutionException;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob;
    static /* synthetic */ Class class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$StatefulMethodInvokingJob;
    static /* synthetic */ Class class$org$quartz$JobDetail;

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public void setJobListenerNames(String[] names) {
        this.jobListenerNames = names;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected Class resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, this.beanClassLoader);
    }

    public void afterPropertiesSet() throws ClassNotFoundException, NoSuchMethodException {
        String name;
        this.prepare();
        String string = name = this.name != null ? this.name : this.beanName;
        Class clazz = this.concurrent ? (class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob == null ? (class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob = MethodInvokingJobDetailFactoryBean.class$("org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean$MethodInvokingJob")) : class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob) : (class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$StatefulMethodInvokingJob == null ? (class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$StatefulMethodInvokingJob = MethodInvokingJobDetailFactoryBean.class$("org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean$StatefulMethodInvokingJob")) : class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$StatefulMethodInvokingJob);
        Class jobClass = clazz;
        this.jobDetail = new JobDetail(name, this.group, jobClass);
        this.jobDetail.getJobDataMap().put((Object)"methodInvoker", this);
        this.jobDetail.setVolatility(true);
        this.jobDetail.setDurability(true);
        if (this.jobListenerNames != null) {
            for (int i = 0; i < this.jobListenerNames.length; ++i) {
                this.jobDetail.addJobListener(this.jobListenerNames[i]);
            }
        }
        this.postProcessJobDetail(this.jobDetail);
    }

    protected void postProcessJobDetail(JobDetail jobDetail) {
    }

    public Class getTargetClass() {
        Class<?> targetClass = super.getTargetClass();
        if (targetClass == null && this.targetBeanName != null) {
            Assert.state(this.beanFactory != null, "BeanFactory must be set when using 'targetBeanName'");
            targetClass = this.beanFactory.getType(this.targetBeanName);
        }
        return targetClass;
    }

    public Object getTargetObject() {
        Object targetObject = super.getTargetObject();
        if (targetObject == null && this.targetBeanName != null) {
            Assert.state(this.beanFactory != null, "BeanFactory must be set when using 'targetBeanName'");
            targetObject = this.beanFactory.getBean(this.targetBeanName);
        }
        return targetObject;
    }

    public Object getObject() {
        return this.jobDetail;
    }

    public Class getObjectType() {
        return class$org$quartz$JobDetail == null ? (class$org$quartz$JobDetail = MethodInvokingJobDetailFactoryBean.class$("org.quartz.JobDetail")) : class$org$quartz$JobDetail;
    }

    public boolean isSingleton() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class StatefulMethodInvokingJob
    extends MethodInvokingJob
    implements StatefulJob {
    }

    public static class MethodInvokingJob
    extends QuartzJobBean {
        protected static final Log logger = LogFactory.getLog(class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob == null ? (class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob = MethodInvokingJobDetailFactoryBean.class$("org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean$MethodInvokingJob")) : class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob);
        private MethodInvoker methodInvoker;

        public void setMethodInvoker(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
        }

        protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
            try {
                this.methodInvoker.invoke();
            }
            catch (InvocationTargetException ex) {
                String errorMessage = this.getInvocationFailureMessage();
                logger.warn(errorMessage, ex.getTargetException());
                if (ex.getTargetException() instanceof JobExecutionException) {
                    throw (JobExecutionException)ex.getTargetException();
                }
                if (oldJobExecutionExceptionConstructor != null) {
                    InvocationTargetException jobEx = ex.getTargetException() instanceof Exception ? (Exception)ex.getTargetException() : ex;
                    throw (JobExecutionException)BeanUtils.instantiateClass(oldJobExecutionExceptionConstructor, errorMessage, jobEx, Boolean.FALSE);
                }
                throw new JobExecutionException(errorMessage, ex.getTargetException());
            }
            catch (Exception ex) {
                String errorMessage = this.getInvocationFailureMessage();
                logger.warn(errorMessage, ex);
                if (oldJobExecutionExceptionConstructor != null) {
                    throw (JobExecutionException)BeanUtils.instantiateClass(oldJobExecutionExceptionConstructor, errorMessage, ex, Boolean.FALSE);
                }
                throw new JobExecutionException(errorMessage, ex);
            }
        }

        private String getInvocationFailureMessage() {
            return "Invocation of method '" + this.methodInvoker.getTargetMethod() + "' on target class [" + this.methodInvoker.getTargetClass() + "] failed";
        }
    }
}

