/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.annotation;

import java.io.IOException;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.springframework.util.ClassUtils;

public class AnnotationSessionFactoryBean
extends LocalSessionFactoryBean
implements ResourceLoaderAware {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private Class[] annotatedClasses;
    private String[] annotatedPackages;
    private String[] packagesToScan;
    private TypeFilter[] entityTypeFilters = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false), new AnnotationTypeFilter(org.hibernate.annotations.Entity.class, false)};
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public AnnotationSessionFactoryBean() {
        this.setConfigurationClass((Class)AnnotationConfiguration.class);
    }

    public void setConfigurationClass(Class configurationClass) {
        if (configurationClass == null || !AnnotationConfiguration.class.isAssignableFrom(configurationClass)) {
            throw new IllegalArgumentException("AnnotationSessionFactoryBean only supports AnnotationConfiguration or subclasses");
        }
        super.setConfigurationClass(configurationClass);
    }

    public void setAnnotatedClasses(Class[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public void setAnnotatedPackages(String[] annotatedPackages) {
        this.annotatedPackages = annotatedPackages;
    }

    public void setPackagesToScan(String[] packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void setEntityTypeFilters(TypeFilter[] entityTypeFilters) {
        this.entityTypeFilters = entityTypeFilters;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = resourceLoader != null ? ResourcePatternUtils.getResourcePatternResolver(resourceLoader) : new PathMatchingResourcePatternResolver();
    }

    protected void postProcessMappings(Configuration config) throws HibernateException {
        int n;
        int n2;
        Object[] objectArray;
        AnnotationConfiguration annConfig = (AnnotationConfiguration)config;
        if (this.annotatedClasses != null) {
            objectArray = this.annotatedClasses;
            n2 = this.annotatedClasses.length;
            n = 0;
            while (n < n2) {
                Object annotatedClass = objectArray[n];
                annConfig.addAnnotatedClass((Class)annotatedClass);
                ++n;
            }
        }
        if (this.annotatedPackages != null) {
            objectArray = this.annotatedPackages;
            n2 = this.annotatedPackages.length;
            n = 0;
            while (n < n2) {
                Object annotatedPackage = objectArray[n];
                annConfig.addPackage((String)annotatedPackage);
                ++n;
            }
        }
        this.scanPackages(annConfig);
    }

    protected void scanPackages(AnnotationConfiguration config) {
        if (this.packagesToScan != null) {
            try {
                String[] stringArray = this.packagesToScan;
                int n = this.packagesToScan.length;
                int n2 = 0;
                while (n2 < n) {
                    String pkg = stringArray[n2];
                    String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath(pkg) + RESOURCE_PATTERN;
                    Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                    CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory(this.resourcePatternResolver);
                    Resource[] resourceArray = resources;
                    int n3 = resources.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Resource resource = resourceArray[n4];
                        if (resource.isReadable()) {
                            MetadataReader reader = readerFactory.getMetadataReader(resource);
                            String className = reader.getClassMetadata().getClassName();
                            if (this.matchesFilter(reader, readerFactory)) {
                                config.addAnnotatedClass(this.resourcePatternResolver.getClassLoader().loadClass(className));
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (IOException ex) {
                throw new MappingException("Failed to scan classpath for unlisted classes", ex);
            }
            catch (ClassNotFoundException ex) {
                throw new MappingException("Failed to load annotated classes from classpath", ex);
            }
        }
    }

    private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (this.entityTypeFilters != null) {
            TypeFilter[] typeFilterArray = this.entityTypeFilters;
            int n = this.entityTypeFilters.length;
            int n2 = 0;
            while (n2 < n) {
                TypeFilter filter = typeFilterArray[n2];
                if (filter.match(reader, readerFactory)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected final void postProcessConfiguration(Configuration config) throws HibernateException {
        this.postProcessAnnotationConfiguration((AnnotationConfiguration)config);
    }

    protected void postProcessAnnotationConfiguration(AnnotationConfiguration config) throws HibernateException {
    }
}

