/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.springframework.mock.web.portlet.MockBaseURL;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MockPortletURL
extends MockBaseURL
implements PortletURL {
    public static final String URL_TYPE_RENDER = "render";
    public static final String URL_TYPE_ACTION = "action";
    private final PortalContext portalContext;
    private final String urlType;
    private WindowState windowState;
    private PortletMode portletMode;

    public MockPortletURL(PortalContext portalContext, String urlType) {
        Assert.notNull(portalContext, "PortalContext is required");
        this.portalContext = portalContext;
        this.urlType = urlType;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!CollectionUtils.contains(this.portalContext.getSupportedWindowStates(), (Object)windowState)) {
            throw new WindowStateException("WindowState not supported", windowState);
        }
        this.windowState = windowState;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!CollectionUtils.contains(this.portalContext.getSupportedPortletModes(), (Object)portletMode)) {
            throw new PortletModeException("PortletMode not supported", portletMode);
        }
        this.portletMode = portletMode;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void removePublicRenderParameter(String name) {
        this.parameters.remove(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.encodeParameter("urlType", this.urlType));
        if (this.windowState != null) {
            sb.append(";").append(this.encodeParameter("windowState", this.windowState.toString()));
        }
        if (this.portletMode != null) {
            sb.append(";").append(this.encodeParameter("portletMode", this.portletMode.toString()));
        }
        for (Map.Entry entry : this.parameters.entrySet()) {
            sb.append(";").append(this.encodeParameter("param_" + (String)entry.getKey(), (String[])entry.getValue()));
        }
        return String.valueOf(this.isSecure() ? "https:" : "http:") + "//localhost/mockportlet?" + sb.toString();
    }
}

