/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.mock.web.portlet.MockActionRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.multipart.MultipartActionRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockMultipartActionRequest
extends MockActionRequest
implements MultipartActionRequest {
    private final MultiValueMap<String, MultipartFile> multipartFiles = new LinkedMultiValueMap<String, MultipartFile>();

    public void addFile(MultipartFile file) {
        Assert.notNull(file, "MultipartFile must not be null");
        this.multipartFiles.add(file.getName(), file);
    }

    public Iterator<String> getFileNames() {
        return this.getFileMap().keySet().iterator();
    }

    public MultipartFile getFile(String name) {
        return this.multipartFiles.getFirst(name);
    }

    public List<MultipartFile> getFiles(String name) {
        List multipartFiles = (List)this.multipartFiles.get(name);
        if (multipartFiles != null) {
            return multipartFiles;
        }
        return Collections.emptyList();
    }

    public Map<String, MultipartFile> getFileMap() {
        return Collections.unmodifiableMap(this.multipartFiles.toSingleValueMap());
    }

    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return new LinkedMultiValueMap<String, MultipartFile>(Collections.unmodifiableMap(this.multipartFiles));
    }
}

