/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.FileTypeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockRequestDispatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServletContext
implements ServletContext {
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ResourceLoader resourceLoader;
    private final String resourceBasePath;
    private String contextPath = "";
    private final Map<String, ServletContext> contexts = new HashMap<String, ServletContext>();
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String servletContextName = "MockServletContext";
    private int minorVersion = 5;

    public MockServletContext() {
        this("", null);
    }

    public MockServletContext(String resourceBasePath) {
        this(resourceBasePath, null);
    }

    public MockServletContext(ResourceLoader resourceLoader) {
        this("", resourceLoader);
    }

    public MockServletContext(String resourceBasePath, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
        String tempDir = System.getProperty(TEMP_DIR_SYSTEM_PROPERTY);
        if (tempDir != null) {
            this.attributes.put("javax.servlet.context.tempdir", new File(tempDir));
        }
    }

    protected String getResourceLocation(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return String.valueOf(this.resourceBasePath) + path;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath != null ? contextPath : "";
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    public void registerContext(String contextPath, ServletContext context) {
        this.contexts.put(contextPath, context);
    }

    @Override
    public ServletContext getContext(String contextPath) {
        if (this.contextPath.equals(contextPath)) {
            return this;
        }
        return this.contexts.get(contextPath);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public String getMimeType(String filePath) {
        return MimeTypeResolver.getMimeType(filePath);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        Object[] fileList;
        Resource resource;
        String actualPath;
        block5: {
            actualPath = path.endsWith("/") ? path : String.valueOf(path) + "/";
            resource = this.resourceLoader.getResource(this.getResourceLocation(actualPath));
            File file = resource.getFile();
            fileList = file.list();
            if (!ObjectUtils.isEmpty(fileList)) break block5;
            return null;
        }
        try {
            LinkedHashSet<String> resourcePaths = new LinkedHashSet<String>(fileList.length);
            Object[] objectArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                Object fileEntry = objectArray[n2];
                String resultPath = String.valueOf(actualPath) + (String)fileEntry;
                if (resource.createRelative((String)fileEntry).getFile().isDirectory()) {
                    resultPath = String.valueOf(resultPath) + "/";
                }
                resourcePaths.add(resultPath);
                ++n2;
            }
            return resourcePaths;
        }
        catch (IOException ex) {
            this.logger.warn("Couldn't get resource paths for " + resource, ex);
            return null;
        }
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        if (!resource.exists()) {
            return null;
        }
        try {
            return resource.getURL();
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.logger.warn("Couldn't get URL for " + resource, ex);
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        if (!resource.exists()) {
            return null;
        }
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            this.logger.warn("Couldn't open InputStream for " + resource, ex);
            return null;
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
        }
        return new MockRequestDispatcher(path);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String path) {
        return null;
    }

    @Override
    public Servlet getServlet(String name) {
        return null;
    }

    @Override
    public Enumeration<Servlet> getServlets() {
        return Collections.enumeration(new HashSet());
    }

    @Override
    public Enumeration<String> getServletNames() {
        return Collections.enumeration(new HashSet());
    }

    @Override
    public void log(String message) {
        this.logger.info(message);
    }

    @Override
    public void log(Exception ex, String message) {
        this.logger.info(message, ex);
    }

    @Override
    public void log(String message, Throwable ex) {
        this.logger.info(message, ex);
    }

    @Override
    public String getRealPath(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            this.logger.warn("Couldn't determine real path of resource " + resource, ex);
            return null;
        }
    }

    @Override
    public String getServerInfo() {
        return "MockServletContext";
    }

    @Override
    public String getInitParameter(String name) {
        Assert.notNull(name, "Parameter name must not be null");
        return this.initParameters.get(name);
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull(name, "Parameter name must not be null");
        this.initParameters.put(name, value);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration((Collection)this.initParameters.keySet());
    }

    @Override
    public Object getAttribute(String name) {
        Assert.notNull(name, "Attribute name must not be null");
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration((Collection)this.attributes.keySet());
    }

    @Override
    public void setAttribute(String name, Object value) {
        Assert.notNull(name, "Attribute name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    @Override
    public void removeAttribute(String name) {
        Assert.notNull(name, "Attribute name must not be null");
        this.attributes.remove(name);
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    @Override
    public String getServletContextName() {
        return this.servletContextName;
    }

    public void setMinorVersion(int minorVersion) {
        if (minorVersion < 3 || minorVersion > 5) {
            throw new IllegalArgumentException("Only Servlet minor versions between 3 and 5 are supported");
        }
        this.minorVersion = minorVersion;
    }

    private static class MimeTypeResolver {
        private MimeTypeResolver() {
        }

        public static String getMimeType(String filePath) {
            return FileTypeMap.getDefaultFileTypeMap().getContentType(filePath);
        }
    }
}

