/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockMultipartHttpServletRequest
extends MockHttpServletRequest
implements MultipartHttpServletRequest {
    private final MultiValueMap<String, MultipartFile> multipartFiles = new LinkedMultiValueMap<String, MultipartFile>();

    public void addFile(MultipartFile file) {
        Assert.notNull(file, "MultipartFile must not be null");
        this.multipartFiles.add(file.getName(), file);
    }

    @Override
    public Iterator<String> getFileNames() {
        return this.getFileMap().keySet().iterator();
    }

    @Override
    public MultipartFile getFile(String name) {
        return this.multipartFiles.getFirst(name);
    }

    @Override
    public List<MultipartFile> getFiles(String name) {
        List multipartFiles = (List)this.multipartFiles.get(name);
        if (multipartFiles != null) {
            return multipartFiles;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, MultipartFile> getFileMap() {
        return Collections.unmodifiableMap(this.multipartFiles.toSingleValueMap());
    }

    @Override
    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return new LinkedMultiValueMap<String, MultipartFile>(Collections.unmodifiableMap(this.multipartFiles));
    }
}

