/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.util.Assert;

public class DataSourceInitializer
implements InitializingBean {
    private DataSource dataSource;
    private DatabasePopulator databasePopulator;
    private boolean enabled = true;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDatabasePopulator(DatabasePopulator databasePopulator) {
        this.databasePopulator = databasePopulator;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.enabled) {
            Assert.state(this.dataSource != null, "DataSource must be provided");
            Assert.state(this.databasePopulator != null, "DatabasePopulator must be provided");
            this.databasePopulator.populate(this.dataSource.getConnection());
        }
    }
}

