/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.metadata.DerbyTableMetaDataProvider;
import org.springframework.jdbc.core.metadata.GenericTableMetaDataProvider;
import org.springframework.jdbc.core.metadata.HsqlTableMetaDataProvider;
import org.springframework.jdbc.core.metadata.OracleTableMetaDataProvider;
import org.springframework.jdbc.core.metadata.PostgresTableMetaDataProvider;
import org.springframework.jdbc.core.metadata.TableMetaDataContext;
import org.springframework.jdbc.core.metadata.TableMetaDataProvider;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public class TableMetaDataProviderFactory {
    private static final Log logger = LogFactory.getLog(TableMetaDataProviderFactory.class);

    public static TableMetaDataProvider createMetaDataProvider(DataSource dataSource, final TableMetaDataContext context) {
        try {
            return (TableMetaDataProvider)JdbcUtils.extractDatabaseMetaData(dataSource, new DatabaseMetaDataCallback(){

                public Object processMetaData(DatabaseMetaData databaseMetaData) throws SQLException, MetaDataAccessException {
                    String databaseProductName = JdbcUtils.commonDatabaseName(databaseMetaData.getDatabaseProductName());
                    boolean accessTableColumnMetaData = context.isAccessTableColumnMetaData();
                    GenericTableMetaDataProvider provider = "Oracle".equals(databaseProductName) ? new OracleTableMetaDataProvider(databaseMetaData, context.isOverrideIncludeSynonymsDefault()) : ("HSQL Database Engine".equals(databaseProductName) ? new HsqlTableMetaDataProvider(databaseMetaData) : ("PostgreSQL".equals(databaseProductName) ? new PostgresTableMetaDataProvider(databaseMetaData) : ("Apache Derby".equals(databaseProductName) ? new DerbyTableMetaDataProvider(databaseMetaData) : new GenericTableMetaDataProvider(databaseMetaData))));
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using " + provider.getClass().getName());
                    }
                    provider.initializeWithMetaData(databaseMetaData);
                    if (accessTableColumnMetaData) {
                        provider.initializeWithTableColumnMetaData(databaseMetaData, context.getCatalogName(), context.getSchemaName(), context.getTableName());
                    }
                    return provider;
                }
            });
        }
        catch (MetaDataAccessException e) {
            throw new DataAccessResourceFailureException("Error retreiving database metadata", e);
        }
    }
}

