/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequest;
import org.springframework.util.Assert;

public class SimpleClientHttpRequestFactory
implements ClientHttpRequestFactory {
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        URLConnection urlConnection = uri.toURL().openConnection();
        Assert.isInstanceOf(HttpURLConnection.class, urlConnection);
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        this.prepareConnection(connection, httpMethod.name());
        return new SimpleClientHttpRequest(connection);
    }

    protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
        connection.setDoInput(true);
        if ("GET".equals(httpMethod)) {
            connection.setInstanceFollowRedirects(true);
        } else {
            connection.setInstanceFollowRedirects(false);
        }
        if ("PUT".equals(httpMethod) || "POST".equals(httpMethod)) {
            connection.setDoOutput(true);
        } else {
            connection.setDoOutput(false);
        }
        connection.setRequestMethod(httpMethod);
    }
}

