/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.joda;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.datetime.joda.DateTimeParser;
import org.springframework.format.datetime.joda.MillisecondInstantPrinter;
import org.springframework.format.datetime.joda.ReadableInstantPrinter;
import org.springframework.format.datetime.joda.ReadablePartialPrinter;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JodaDateTimeFormatAnnotationFormatterFactory
implements AnnotationFormatterFactory<org.springframework.format.annotation.DateTimeFormat> {
    private final Set<Class<?>> fieldTypes;

    public JodaDateTimeFormatAnnotationFormatterFactory() {
        HashSet<Class> rawFieldTypes = new HashSet<Class>(8);
        rawFieldTypes.add(LocalDate.class);
        rawFieldTypes.add(LocalTime.class);
        rawFieldTypes.add(LocalDateTime.class);
        rawFieldTypes.add(DateTime.class);
        rawFieldTypes.add(DateMidnight.class);
        rawFieldTypes.add(Date.class);
        rawFieldTypes.add(Calendar.class);
        rawFieldTypes.add(Long.class);
        this.fieldTypes = Collections.unmodifiableSet(rawFieldTypes);
    }

    @Override
    public Set<Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public Printer<?> getPrinter(org.springframework.format.annotation.DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatter formatter = this.configureDateTimeFormatterFrom(annotation);
        if (ReadableInstant.class.isAssignableFrom(fieldType)) {
            return new ReadableInstantPrinter(formatter);
        }
        if (ReadablePartial.class.isAssignableFrom(fieldType)) {
            return new ReadablePartialPrinter(formatter);
        }
        if (Calendar.class.isAssignableFrom(fieldType)) {
            return new ReadableInstantPrinter(formatter);
        }
        return new MillisecondInstantPrinter(formatter);
    }

    @Override
    public Parser<DateTime> getParser(org.springframework.format.annotation.DateTimeFormat annotation, Class<?> fieldType) {
        return new DateTimeParser(this.configureDateTimeFormatterFrom(annotation));
    }

    private DateTimeFormatter configureDateTimeFormatterFrom(org.springframework.format.annotation.DateTimeFormat annotation) {
        if (StringUtils.hasLength(annotation.pattern())) {
            return this.forPattern(annotation.pattern());
        }
        if (annotation.iso() != DateTimeFormat.ISO.NONE) {
            return this.forIso(annotation.iso());
        }
        return this.forStyle(annotation.style());
    }

    private DateTimeFormatter forPattern(String pattern) {
        return DateTimeFormat.forPattern((String)pattern);
    }

    private DateTimeFormatter forIso(DateTimeFormat.ISO iso) {
        if (iso == DateTimeFormat.ISO.DATE) {
            return ISODateTimeFormat.date();
        }
        if (iso == DateTimeFormat.ISO.TIME) {
            return ISODateTimeFormat.time();
        }
        return ISODateTimeFormat.dateTime();
    }

    private DateTimeFormatter forStyle(String style) {
        return DateTimeFormat.forStyle((String)style);
    }
}

