/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.common;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionUtils {
    public static <T> T convert(EvaluationContext context, Object value, Class<T> targetType) throws EvaluationException {
        if (targetType == null || ClassUtils.isAssignableValue(targetType, value)) {
            return (T)value;
        }
        if (context != null) {
            return (T)context.getTypeConverter().convertValue(value, TypeDescriptor.valueOf(targetType));
        }
        throw new EvaluationException("Cannot convert value '" + value + "' to type '" + targetType.getName() + "'");
    }
}

