/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticMessageSource
extends AbstractMessageSource {
    private final Map<String, MessageFormat> messages = new HashMap<String, MessageFormat>();

    @Override
    protected MessageFormat resolveCode(String code, Locale locale) {
        return this.messages.get(String.valueOf(code) + "_" + locale.toString());
    }

    public void addMessage(String code, Locale locale, String msg) {
        Assert.notNull(code, "Code must not be null");
        Assert.notNull(locale, "Locale must not be null");
        Assert.notNull(msg, "Message must not be null");
        this.messages.put(String.valueOf(code) + "_" + locale.toString(), this.createMessageFormat(msg, locale));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added message [" + msg + "] for code [" + code + "] and Locale [" + locale + "]");
        }
    }

    public void addMessages(Map<String, String> messages, Locale locale) {
        Assert.notNull(messages, "Messages Map must not be null");
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            this.addMessage(entry.getKey(), locale, entry.getValue());
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.messages;
    }
}

