/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.context.LifecycleProcessor;
import org.springframework.context.Phased;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLifecycleProcessor
implements LifecycleProcessor,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile long timeoutPerShutdownPhase = 30000L;
    private volatile boolean running;
    private volatile ConfigurableListableBeanFactory beanFactory;

    public void setTimeoutPerShutdownPhase(long timeoutPerShutdownPhase) {
        this.timeoutPerShutdownPhase = timeoutPerShutdownPhase;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Override
    public void start() {
        this.startBeans(false);
        this.running = true;
    }

    @Override
    public void stop() {
        this.stopBeans();
        this.running = false;
    }

    @Override
    public void onRefresh() {
        this.startBeans(true);
        this.running = true;
    }

    @Override
    public void onClose() {
        this.stopBeans();
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    private void startBeans(boolean autoStartupOnly) {
        Map<String, Lifecycle> lifecycleBeans = this.getLifecycleBeans();
        HashMap<Integer, LifecycleGroup> phases = new HashMap<Integer, LifecycleGroup>();
        for (Map.Entry<String, Lifecycle> entry : lifecycleBeans.entrySet()) {
            Lifecycle lifecycle = entry.getValue();
            if (autoStartupOnly && (!(lifecycle instanceof SmartLifecycle) || !((SmartLifecycle)lifecycle).isAutoStartup())) continue;
            int phase = DefaultLifecycleProcessor.getPhase(lifecycle);
            LifecycleGroup group = (LifecycleGroup)phases.get(phase);
            if (group == null) {
                group = new LifecycleGroup(phase, this.timeoutPerShutdownPhase, lifecycleBeans);
                phases.put(phase, group);
            }
            group.add(entry.getKey(), lifecycle);
        }
        if (phases.size() > 0) {
            ArrayList keys = new ArrayList(phases.keySet());
            Collections.sort(keys);
            for (Integer key : keys) {
                ((LifecycleGroup)phases.get(key)).start();
            }
        }
    }

    private void doStart(Map<String, ? extends Lifecycle> lifecycleBeans, String beanName) {
        Lifecycle bean = lifecycleBeans.get(beanName);
        if (bean != null && !this.equals(bean)) {
            String[] dependenciesForBean;
            String[] stringArray = dependenciesForBean = this.beanFactory.getDependenciesForBean(beanName);
            int n = dependenciesForBean.length;
            int n2 = 0;
            while (n2 < n) {
                String dependency = stringArray[n2];
                this.doStart(lifecycleBeans, dependency);
                ++n2;
            }
            if (!bean.isRunning()) {
                bean.start();
            }
            lifecycleBeans.remove(beanName);
        }
    }

    private void stopBeans() {
        Map<String, Lifecycle> lifecycleBeans = this.getLifecycleBeans();
        HashMap<Integer, LifecycleGroup> phases = new HashMap<Integer, LifecycleGroup>();
        for (Map.Entry<String, Lifecycle> entry : lifecycleBeans.entrySet()) {
            Lifecycle lifecycle = entry.getValue();
            int shutdownOrder = DefaultLifecycleProcessor.getPhase(lifecycle);
            LifecycleGroup group = (LifecycleGroup)phases.get(shutdownOrder);
            if (group == null) {
                group = new LifecycleGroup(shutdownOrder, this.timeoutPerShutdownPhase, lifecycleBeans);
                phases.put(shutdownOrder, group);
            }
            group.add(entry.getKey(), lifecycle);
        }
        if (phases.size() > 0) {
            ArrayList keys = new ArrayList(phases.keySet());
            Collections.sort(keys, Collections.reverseOrder());
            for (Integer key : keys) {
                ((LifecycleGroup)phases.get(key)).stop();
            }
        }
    }

    private void doStop(Map<String, ? extends Lifecycle> lifecycleBeans, String beanName, final CountDownLatch latch) {
        Lifecycle bean = lifecycleBeans.get(beanName);
        if (bean != null) {
            String[] dependentBeans;
            String[] stringArray = dependentBeans = this.beanFactory.getDependentBeans(beanName);
            int n = dependentBeans.length;
            int n2 = 0;
            while (n2 < n) {
                String dependentBean = stringArray[n2];
                this.doStop(lifecycleBeans, dependentBean, latch);
                ++n2;
            }
            if (bean.isRunning()) {
                if (bean instanceof SmartLifecycle) {
                    ((SmartLifecycle)bean).stop(new Runnable(){

                        public void run() {
                            latch.countDown();
                        }
                    });
                } else {
                    bean.stop();
                }
            } else if (bean instanceof SmartLifecycle) {
                latch.countDown();
            }
            lifecycleBeans.remove(beanName);
        }
    }

    private Map<String, Lifecycle> getLifecycleBeans() {
        String[] beanNames;
        LinkedHashMap<String, Lifecycle> beans = new LinkedHashMap<String, Lifecycle>();
        String[] stringArray = beanNames = this.beanFactory.getBeanNamesForType(Lifecycle.class, false, false);
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            Lifecycle bean;
            String beanNameToCheck;
            String beanName = stringArray[n2];
            String beanNameToRegister = BeanFactoryUtils.transformedBeanName(beanName);
            boolean isFactoryBean = this.beanFactory.isFactoryBean(beanNameToRegister);
            String string = beanNameToCheck = isFactoryBean ? "&" + beanName : beanName;
            if ((this.beanFactory.containsSingleton(beanNameToRegister) && (!isFactoryBean || Lifecycle.class.isAssignableFrom(this.beanFactory.getType(beanNameToCheck))) || SmartLifecycle.class.isAssignableFrom(this.beanFactory.getType(beanNameToCheck))) && (bean = this.beanFactory.getBean(beanNameToCheck, Lifecycle.class)) != this) {
                beans.put(beanNameToRegister, bean);
            }
            ++n2;
        }
        return beans;
    }

    private static int getPhase(Lifecycle bean) {
        return bean instanceof Phased ? ((Phased)((Object)bean)).getPhase() : 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LifecycleGroup {
        private final List<LifecycleGroupMember> members = new ArrayList<LifecycleGroupMember>();
        private Map<String, ? extends Lifecycle> lifecycleBeans;
        private volatile int smartMemberCount;
        private final int phase;
        private final long timeout;

        LifecycleGroup(int phase, long timeout, Map<String, ? extends Lifecycle> lifecycleBeans) {
            this.lifecycleBeans = DefaultLifecycleProcessor.this.getLifecycleBeans();
            this.phase = phase;
            this.timeout = timeout;
            this.lifecycleBeans = lifecycleBeans;
        }

        void add(String name, Lifecycle bean) {
            if (bean instanceof SmartLifecycle) {
                ++this.smartMemberCount;
            }
            this.members.add(new LifecycleGroupMember(name, bean));
        }

        void start() {
            if (this.members.size() == 0) {
                return;
            }
            Collections.sort(this.members);
            for (LifecycleGroupMember member : this.members) {
                if (!this.lifecycleBeans.containsKey(member.name)) continue;
                DefaultLifecycleProcessor.this.doStart(this.lifecycleBeans, member.name);
            }
        }

        void stop() {
            if (this.members.size() == 0) {
                return;
            }
            Collections.sort(this.members, Collections.reverseOrder());
            CountDownLatch latch = new CountDownLatch(this.smartMemberCount);
            for (LifecycleGroupMember member : this.members) {
                if (this.lifecycleBeans.containsKey(member.name)) {
                    DefaultLifecycleProcessor.this.doStop(this.lifecycleBeans, member.name, latch);
                    continue;
                }
                if (!(member.bean instanceof SmartLifecycle)) continue;
                latch.countDown();
            }
            try {
                latch.await(this.timeout, TimeUnit.MILLISECONDS);
                if (latch.getCount() != 0L && DefaultLifecycleProcessor.this.logger.isWarnEnabled()) {
                    DefaultLifecycleProcessor.this.logger.warn("failed to shutdown beans with phase value " + this.phase + " within timeout of " + this.timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifecycleGroupMember
    implements Comparable<LifecycleGroupMember> {
        private final String name;
        private final Lifecycle bean;

        LifecycleGroupMember(String name, Lifecycle bean) {
            this.name = name;
            this.bean = bean;
        }

        @Override
        public int compareTo(LifecycleGroupMember other) {
            int otherOrder;
            int thisOrder = DefaultLifecycleProcessor.getPhase(this.bean);
            return thisOrder == (otherOrder = DefaultLifecycleProcessor.getPhase(other.bean)) ? 0 : (thisOrder < otherOrder ? -1 : 1);
        }
    }
}

