/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintStream;
import java.util.Date;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class ConsoleLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 379016827175700983L;
    private static final String[] LEVELNAMES = new String[]{"Trace", "Debug", "Info", "Warn", "Error"};
    private static int LEVEL_TRACE = 0;
    private static int LEVEL_DEBUG = 1;
    private static int LEVEL_INFO = 2;
    private static int LEVEL_WARN = 3;
    private static int LEVEL_ERROR = 4;
    private Output[] outputs = new Output[]{Output.OUT, Output.OUT, Output.OUT, Output.ERR, Output.ERR};
    private Object lineSeparator = System.getProperty("line.separator");

    ConsoleLogger(String name) {
        this.name = name;
        String level = System.getProperty("slf4j.console.minlevel");
        int lvlint = LEVEL_INFO;
        if (level != null && level.length() > 0) {
            switch (level.toLowerCase().charAt(0)) {
                case 'e': {
                    lvlint = LEVEL_ERROR;
                    break;
                }
                case 'w': {
                    lvlint = LEVEL_WARN;
                    break;
                }
                case 'i': {
                    lvlint = LEVEL_INFO;
                    break;
                }
                case 't': {
                    lvlint = LEVEL_TRACE;
                }
            }
        }
        for (int i = 0; i < lvlint; ++i) {
            this.outputs[i] = Output.NO;
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.outputs[LEVEL_TRACE] != Output.NO;
    }

    @Override
    public void trace(String msg) {
        this.log(LEVEL_TRACE, msg, null);
    }

    @Override
    public void trace(String format, Object arg) {
        this.formatAndLog(LEVEL_TRACE, format, arg, null);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.formatAndLog(LEVEL_TRACE, format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object[] argArray) {
        this.formatAndLog(LEVEL_TRACE, format, argArray);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(LEVEL_TRACE, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.outputs[LEVEL_DEBUG] != Output.NO;
    }

    @Override
    public void debug(String msg) {
        this.log(LEVEL_DEBUG, msg, null);
    }

    @Override
    public void debug(String format, Object arg) {
        this.formatAndLog(LEVEL_DEBUG, format, arg, null);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.formatAndLog(LEVEL_DEBUG, format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object[] argArray) {
        this.formatAndLog(LEVEL_DEBUG, format, argArray);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(LEVEL_DEBUG, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.outputs[LEVEL_INFO] != Output.NO;
    }

    @Override
    public void info(String msg) {
        this.log(LEVEL_INFO, msg, null);
    }

    @Override
    public void info(String format, Object arg) {
        this.formatAndLog(LEVEL_INFO, format, arg, null);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(LEVEL_INFO, format, arg1, arg2);
    }

    @Override
    public void info(String format, Object[] argArray) {
        this.formatAndLog(LEVEL_INFO, format, argArray);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(LEVEL_INFO, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.outputs[LEVEL_WARN] != Output.NO;
    }

    @Override
    public void warn(String msg) {
        this.log(LEVEL_WARN, msg, null);
    }

    @Override
    public void warn(String format, Object arg) {
        this.formatAndLog(LEVEL_WARN, format, arg, null);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(LEVEL_WARN, format, arg1, arg2);
    }

    @Override
    public void warn(String format, Object[] argArray) {
        this.formatAndLog(LEVEL_WARN, format, argArray);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(LEVEL_WARN, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.outputs[LEVEL_ERROR] != Output.NO;
    }

    @Override
    public void error(String msg) {
        this.log(LEVEL_ERROR, msg, null);
    }

    @Override
    public void error(String format, Object arg) {
        this.formatAndLog(LEVEL_ERROR, format, arg, null);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(LEVEL_ERROR, format, arg1, arg2);
    }

    @Override
    public void error(String format, Object[] argArray) {
        this.formatAndLog(LEVEL_ERROR, format, argArray);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(LEVEL_ERROR, msg, t);
    }

    private void log(int level, String message, Throwable t) {
        if (this.outputs[level] != Output.NO) {
            PrintStream outputStream = this.outputs[level] == Output.ERR ? System.err : System.out;
            StringBuffer buf = new StringBuffer();
            buf.append(new Date());
            buf.append(" [");
            buf.append(Thread.currentThread().getName());
            buf.append("] ");
            buf.append(LEVELNAMES[level]);
            buf.append(" ");
            buf.append(this.name);
            buf.append(" - ");
            buf.append(message);
            buf.append(this.lineSeparator);
            outputStream.print(buf.toString());
            if (t != null) {
                t.printStackTrace(outputStream);
            }
            outputStream.flush();
        }
    }

    private void formatAndLog(int level, String format, Object arg1, Object arg2) {
        FormattingTuple tp = MessageFormatter.format(format, arg1, arg2);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    private void formatAndLog(int level, String format, Object[] argArray) {
        FormattingTuple tp = MessageFormatter.arrayFormat(format, argArray);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    private static enum Output {
        NO,
        OUT,
        ERR;

    }
}

