/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.DBSemaphore;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Util;

public class StdRowLockSemaphore
extends DBSemaphore {
    public static final String SELECT_FOR_LOCK = "SELECT * FROM {0}LOCKS WHERE LOCK_NAME = ? FOR UPDATE";

    public StdRowLockSemaphore() {
        super("QRTZ_", null, SELECT_FOR_LOCK);
    }

    public StdRowLockSemaphore(String tablePrefix, String selectWithLockSQL) {
        super(tablePrefix, selectWithLockSQL, SELECT_FOR_LOCK);
    }

    /*
     * Loose catch block
     */
    protected void executeSQL(Connection conn, String lockName, String expandedSQL) throws LockException {
        block17: {
            Exception ignore22;
            ResultSet rs;
            PreparedStatement ps;
            block16: {
                ps = null;
                rs = null;
                ps = conn.prepareStatement(expandedSQL);
                ps.setString(1, lockName);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName());
                }
                if (!(rs = ps.executeQuery()).next()) {
                    throw new SQLException(Util.rtp("No row exists in table {0}LOCKS for lock named: " + lockName, this.getTablePrefix()));
                }
                Object var8_6 = null;
                if (rs == null) break block16;
                try {
                    rs.close();
                }
                catch (Exception ignore22) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception ignore22) {}
            }
            break block17;
            {
                catch (SQLException sqle) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName());
                    }
                    throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
                }
            }
            catch (Throwable throwable) {
                Exception ignore22;
                Object var8_7 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception ignore22) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception ignore22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    protected String getSelectWithLockSQL() {
        return this.getSQL();
    }

    public void setSelectWithLockSQL(String selectWithLockSQL) {
        this.setSQL(selectWithLockSQL);
    }
}

