/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.WeakHashMap;

public class AbstractDelegateInvocationHandler
implements InvocationHandler {
    private static final Object NOT_INTERCEPTED = new Object();
    private final WeakHashMap<Method, Method> methodMap;
    private Object delegate;

    public AbstractDelegateInvocationHandler(Object delegate) {
        this.delegate = delegate;
        this.methodMap = new WeakHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method delegateMethod = null;
        WeakHashMap<Method, Method> weakHashMap = this.methodMap;
        synchronized (weakHashMap) {
            delegateMethod = this.methodMap.get(method);
            if (delegateMethod == null && (delegateMethod = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes())) != null) {
                this.methodMap.put(method, delegateMethod);
            }
        }
        Object result = this.interceptMethod(delegateMethod, method, args);
        if (result == NOT_INTERCEPTED) {
            result = delegateMethod.invoke(this.delegate, args);
            this.postProcessMethod(delegateMethod, method, args);
        }
        return result;
    }

    protected Object interceptMethod(Method delegateMethod, Method method, Object[] args) {
        return NOT_INTERCEPTED;
    }

    protected void postProcessMethod(Method delegateMethod, Method method, Object[] args) {
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }
}

