/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.polygon;

import java.util.LinkedList;
import java.util.List;
import org.ktde.util.datatypes.Range;

public class LogTree {
    private List<Child> children = new LinkedList<Child>();

    public LogTree(int count, int levelWidth) {
        this(count, levelWidth, 0);
    }

    private LogTree(int count, int levelWidth, int offset) {
        if (count <= levelWidth) {
            for (int i = 0; i < count; ++i) {
                this.children.add(new IndexChild(offset + i));
            }
        } else {
            int ex = count % levelWidth;
            int p = (count - ex) / levelWidth;
            int e = 0;
            int c = 0;
            for (int i = 0; i < levelWidth; ++i) {
                int oc = c;
                c += p;
                if (e < ex) {
                    ++e;
                    ++c;
                }
                Child subtree = new SubTree(c - oc, levelWidth, offset + oc);
                if (((SubTree)subtree).tree.children.size() == 1) {
                    subtree = ((SubTree)subtree).tree.children.get(0);
                }
                this.children.add(subtree);
            }
        }
    }

    public List<Child> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int c = 40;
        for (Child child : this.children) {
            builder.append((char)c);
            c = 44;
            builder.append(child.toString());
        }
        builder.append(")");
        return builder.toString();
    }

    public static interface Child {
        public int getMin();

        public int getMax();
    }

    public class IndexChild
    implements Child {
        private int i;

        public IndexChild(int i) {
            this.i = i;
        }

        public int getIndex() {
            return this.i;
        }

        @Override
        public int getMin() {
            return this.i;
        }

        @Override
        public int getMax() {
            return this.i;
        }

        public String toString() {
            return "" + this.i;
        }
    }

    public class SubTree
    implements Child {
        private LogTree tree;

        public SubTree(int count, int levelWidth, int offset) {
            this.tree = new LogTree(count, levelWidth, offset);
        }

        public LogTree getTree() {
            return this.tree;
        }

        public Range getRange() {
            return new Range(this.getMin(), this.getMax());
        }

        @Override
        public int getMin() {
            return ((Child)this.tree.children.get(0)).getMin();
        }

        @Override
        public int getMax() {
            return ((Child)this.tree.children.get(this.tree.children.size() - 1)).getMax();
        }

        public String toString() {
            return this.tree.toString();
        }
    }
}

