/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.ktde.util.StringUtil;
import org.ktde.util.function.StringConstantFunction;
import org.ktde.util.function.StringFunction;
import org.ktde.util.io.CsvReader;
import org.ktde.util.io.CsvWriter;

public class StringTable
implements Cloneable {
    private List<String> headLine;
    private List<Map<String, String>> lines;

    public StringTable(CsvReader reader) throws IOException {
        this(reader.readLine());
        List<String> line = null;
        int hl = this.headLine.size();
        while ((line = reader.readLine()) != null) {
            int i = 0;
            int l = line.size();
            HashMap<String, String> map = new HashMap<String, String>(hl);
            for (String key : this.headLine) {
                String value = "";
                if (l > i) {
                    value = line.get(i++);
                }
                map.put(key, value);
            }
            this.lines.add(map);
        }
        reader.close();
    }

    private StringTable(List<String> list) {
        this.headLine = list;
        this.lines = new ArrayList<Map<String, String>>();
    }

    public String get(String key, int row) {
        String val = this.lines.get(row).get(key);
        return val == null ? "" : val;
    }

    public void set(String key, int row, String value) {
        this.lines.get(row).put(key, value);
    }

    public int size() {
        return this.lines.size();
    }

    public void renameColumn(String key, String keyNew) {
        int index = this.headLine.indexOf(key);
        if (index > -1) {
            this.headLine.set(index, keyNew);
            for (Map<String, String> line : this.lines) {
                String val = line.get(key);
                if (val != null) {
                    line.remove(key);
                }
                line.put(keyNew, val == null ? "" : val);
            }
        }
    }

    public void addColumn(String key) {
        this.headLine.add(key);
    }

    public void removeColumn(String key) {
        this.headLine.remove(key);
    }

    public void writeTo(CsvWriter writer) throws IOException {
        writer.writeLine(this.headLine);
        ArrayList<String> lineout = new ArrayList<String>();
        lineout.addAll(this.headLine);
        for (Map<String, String> line : this.lines) {
            int i = 0;
            for (String key : this.headLine) {
                String val = line.get(key);
                lineout.set(i++, val == null ? "" : val);
            }
            writer.writeLine(lineout);
        }
        writer.close();
    }

    public StringTable clone() {
        ArrayList<String> headClone = new ArrayList<String>();
        headClone.addAll(this.headLine);
        StringTable that = new StringTable(headClone);
        int hl = this.headLine.size();
        for (Map<String, String> line : this.lines) {
            HashMap<String, String> lineClone = new HashMap<String, String>(hl);
            lineClone.putAll(line);
            that.lines.add(lineClone);
        }
        return that;
    }

    public void retainColumns(Collection<String> keys) {
        ArrayList<String> remove = new ArrayList<String>();
        for (String string : this.headLine) {
            if (keys.contains(string)) continue;
            remove.add(string);
        }
        for (String string : remove) {
            this.removeColumn(string);
        }
    }

    public void cloneColumn(String key, String newKey) {
        this.addColumn(newKey);
        Iterator<Map<String, String>> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Map<String, String> line;
            String val = (line = iterator.next()).get(key);
            line.put(newKey, val == null ? "" : val);
        }
    }

    public void fillColumn(String key, String val) {
        for (Map<String, String> line : this.lines) {
            line.put(key, val == null ? "" : val);
        }
    }

    public void uniqBy(String ... key) {
        LineComparator comparator = new LineComparator(key);
        Collections.sort(this.lines, comparator);
        Map<String, String> before = null;
        ListIterator<Map<String, String>> iter = this.lines.listIterator();
        while (iter.hasNext()) {
            Map<String, String> line = iter.next();
            if (before != null && comparator.compare(before, line) == 0) {
                iter.remove();
                continue;
            }
            before = line;
        }
    }

    public void sortBy(String ... key) {
        Collections.sort(this.lines, new LineComparator(key));
    }

    public void concatenate(StringTable other) {
        this.lines.addAll(other.lines);
    }

    public Map<String, StringTable> splitBy(String key) {
        HashMap<String, StringTable> result = new HashMap<String, StringTable>();
        int hl = this.headLine.size();
        for (Map<String, String> line : this.lines) {
            StringTable other;
            String val = line.get(key);
            if (val == null) {
                val = "";
            }
            if ((other = (StringTable)result.get(val)) == null) {
                ArrayList<String> headClone = new ArrayList<String>();
                headClone.addAll(this.headLine);
                other = new StringTable(headClone);
                result.put(val, other);
            }
            HashMap<String, String> lineClone = new HashMap<String, String>(hl);
            lineClone.putAll(line);
            other.lines.add(lineClone);
        }
        return result;
    }

    public void fillColumn(String key, String joinFromKey, StringTable joinTable, String joinToKey, String valKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map<String, String> line : joinTable.lines) {
            map.put(line.get(joinToKey), line.get(valKey));
        }
        Iterator<Map<String, String>> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Map<String, String> line;
            String fromJoin = (line = iterator.next()).get(joinFromKey);
            String val = (String)map.get(fromJoin);
            line.put(key, val == null ? "" : val);
        }
    }

    public void fillEmptyInColumn(String key, String val) {
        for (Map<String, String> line : this.lines) {
            if (!StringUtil.isEmpty(line.get(key))) continue;
            line.put(key, val);
        }
    }

    public void fillColumn(String key, StringFunction function) {
        for (Map<String, String> line : this.lines) {
            HashMap variables = new HashMap();
            for (Map.Entry<String, String> entry : line.entrySet()) {
                String val = entry.getValue();
                variables.put(entry.getKey(), new StringConstantFunction(val == null ? "" : val));
            }
            line.put(key, (String)function.evaluate(variables));
        }
    }

    private class LineComparator
    implements Comparator<Map<String, String>> {
        private String[] keys;

        public LineComparator(String[] keys) {
            this.keys = keys;
        }

        @Override
        public int compare(Map<String, String> o1, Map<String, String> o2) {
            int comp = 0;
            for (String key : this.keys) {
                String v1 = o1.get(key);
                String v2 = o2.get(key);
                if (v1 == null) {
                    v1 = "";
                }
                if (v2 == null) {
                    v2 = "";
                }
                if ((comp = v1.compareTo(v2)) != 0) break;
            }
            return comp;
        }
    }
}

