/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.ktde.util.io.TcpClientHandler;

public abstract class StreamTcpClientHandler
extends TcpClientHandler
implements Runnable {
    private InputStream in;
    private OutputStream out;
    private boolean stopped;
    private int bufferSize;
    private Thread thread;
    private int contentused;
    private byte[] contents;

    public StreamTcpClientHandler(Socket s) throws IOException {
        super(s);
    }

    @Override
    protected void start() throws IOException {
        this.in = this.getReaderFromSocket(this.getSocket());
        this.out = this.getWriterFromSocket(this.getSocket());
        this.contents = new byte[0];
        this.contentused = 0;
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        byte[] buffer = new byte[this.bufferSize];
        while (!this.stopped) {
            try {
                int read = this.in.read(buffer);
                if (read == -1) {
                    this.disconnect();
                    break;
                }
                int newContentSize = this.contents.length + read - this.contentused;
                byte[] newContent = new byte[newContentSize];
                System.arraycopy(this.contents, 0, newContent, 0, this.contents.length - this.contentused);
                System.arraycopy(buffer, 0, newContent, this.contents.length - this.contentused, read);
                this.contents = newContent;
                this.contentused = this.processIncomingContent(this.contents);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected InputStream getReaderFromSocket(Socket s) throws IOException {
        return s.getInputStream();
    }

    protected OutputStream getWriterFromSocket(Socket s) throws IOException {
        return s.getOutputStream();
    }

    protected abstract int processIncomingContent(byte[] var1);

    protected void writeOutgointConten(byte[] bytes) throws IOException {
        this.out.write(bytes);
        this.out.flush();
    }

    @Override
    protected void informDisconnect() {
    }

    @Override
    protected void disconnect() {
        try {
            if (this.contentused < this.contents.length) {
                byte[] rest = new byte[this.contents.length - this.contentused];
                System.arraycopy(this.contents, this.contentused, rest, 0, this.contents.length - this.contentused);
                this.processIncomingContent(rest);
            }
            this.thread.interrupt();
            this.informDisconnect();
            this.in.close();
            this.out.flush();
            this.out.close();
            super.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

