/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ScrambledOutputStream
extends OutputStream {
    private OutputStream delegate;
    private int[] phrase;
    private int phrasePosition;

    public ScrambledOutputStream(OutputStream delegate, byte[] phrase) {
        this.delegate = delegate;
        if (phrase == null || phrase.length == 0) {
            this.phrase = new int[]{0};
        } else {
            this.phrase = new int[phrase.length];
            for (int i = 0; i < phrase.length; ++i) {
                this.phrase[i] = ScrambledOutputStream.byteToInt(phrase[i]);
            }
        }
        this.phrasePosition = 0;
    }

    public ScrambledOutputStream(OutputStream delegate, String phrase) {
        this(delegate, ScrambledOutputStream.decodeUtf8WithoutWarning(phrase));
    }

    private static byte[] decodeUtf8WithoutWarning(String phrase) {
        try {
            return phrase.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private byte scramble(byte b) {
        int i = ScrambledOutputStream.byteToInt(b);
        int c = this.phrase[this.phrasePosition];
        this.phrasePosition = (this.phrasePosition + 1) % this.phrase.length;
        int r = i ^ c;
        return ScrambledOutputStream.intToByte(r);
    }

    private static byte intToByte(int i) {
        byte b = 0;
        b = i < 128 ? (byte)i : (byte)(i - 256);
        return b;
    }

    private static int byteToInt(byte b) {
        int i = b;
        if (i < 0) {
            i += 128;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.scramble(b[off + i]);
        }
        this.delegate.write(bytes, 0, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (b != -1) {
            byte scrambled = this.scramble(ScrambledOutputStream.intToByte(b));
            b = ScrambledOutputStream.byteToInt(scrambled);
        }
        this.delegate.write(b);
    }
}

