/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.ktde.util.io.ChangingFileInputStream;

public class FileCaller {
    private File outWriting;
    private File outFile;
    private InputStream in;

    public FileCaller(String fileoutname, String fileinname) throws IOException {
        File filein = new File(fileinname);
        if (filein.exists()) {
            filein.delete();
        }
        this.outFile = new File(fileoutname);
        this.outWriting = new File(fileoutname + ".tmp");
        if (this.outFile.exists()) {
            this.outFile.delete();
        }
        ChangingFileInputStream fin = new ChangingFileInputStream(filein);
        this.in = fin;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public String call(String string) throws IOException {
        if (this.outWriting.exists()) {
            this.outWriting.delete();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(this.outWriting));
        out.write(string);
        out.flush();
        out.close();
        while (this.outFile.exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.outWriting.renameTo(this.outFile);
        StringBuffer line = new StringBuffer();
        int c = 0;
        while (c != -1 && c != 10) {
            c = this.in.read();
            if (c == -1 || c == 10) continue;
            line.append((char)c);
        }
        String str = line.toString();
        if (str.startsWith("error")) {
            throw new IOException(str.substring(6));
        }
        return str;
    }

    public static void main(String[] args) throws IOException {
        FileCaller f = new FileCaller("c:/tmp/javatoc", "/tmp/ctojava");
        String result = f.call("998 123,345");
        System.out.println(result);
        result = f.call("999 111,222");
        System.out.println(result);
        result = f.call("exit");
        f.close();
    }
}

