/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ChangingFileInputStream
extends InputStream
implements Runnable {
    private File f;
    private long size;
    private boolean stopped;
    private Thread t;
    private Vector<byte[]> byteArrays;
    private int curPos;
    private byte[] curByteArray;
    private Object readSemaphore = new Object();

    public ChangingFileInputStream(File f) {
        this.f = f;
        this.size = 0L;
        this.byteArrays = new Vector();
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void run() {
        this.stopped = false;
        block4: while (true) {
            try {
                while (!this.stopped) {
                    long curSize = 0L;
                    if (this.f.exists()) {
                        curSize = this.f.length();
                    }
                    if (this.size < curSize) {
                        FileInputStream fin = new FileInputStream(this.f);
                        fin.skip(this.size);
                        int bufSize = 2048;
                        while (curSize > this.size) {
                            long delta = curSize - this.size;
                            if (delta > (long)bufSize) {
                                delta = bufSize;
                            }
                            byte[] bytes = new byte[(int)delta];
                            fin.read(bytes);
                            this.size += delta;
                            this.byteArrays.add(bytes);
                        }
                        fin.close();
                    }
                    try {
                        Thread.sleep(1000L);
                        continue block4;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
        }
    }

    @Override
    public void close() {
        this.stopped = true;
        try {
            this.t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.stopped) {
            return -1;
        }
        int result = -1;
        Object object = this.readSemaphore;
        synchronized (object) {
            if (this.curByteArray == null || this.curPos == this.curByteArray.length) {
                while (!this.stopped && this.byteArrays.isEmpty()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.stopped) {
                    return -1;
                }
                this.curByteArray = this.byteArrays.remove(0);
                this.curPos = 0;
            }
            if ((result = this.curByteArray[this.curPos++]) < 0) {
                result += 256;
            }
        }
        return result;
    }
}

