/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.datatypes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Tree<T> {
    private Folder root;

    public Tree(Folder root) {
        this.root = root;
    }

    public Tree(T value) {
        this.root = new Folder(value);
    }

    public Tree() {
    }

    public Folder getRoot() {
        return this.root;
    }

    public void setRoot(Folder root) {
        this.root = root;
    }

    public String toString() {
        return this.root.toString("", true);
    }

    public class Link
    extends Node {
        private Node target;

        public Link(Node target) {
            this.target = target;
        }

        public Node getTarget() {
            return this.target;
        }

        public void setTarget(Node target) {
            this.target = target;
        }

        @Override
        public T getValue() {
            return this.target.getValue();
        }

        @Override
        public void setValue(T value) {
            this.target.setValue(value);
        }

        @Override
        public String toString(String indent, boolean last) {
            String s = indent + "> Link";
            String tab = indent + (last ? "  " : "| ");
            s = s + this.target.toString(tab, true);
            return s;
        }
    }

    public class Folder
    extends Node {
        private List<Node> nodes;

        public Folder() {
            this.nodes = new ArrayList<Node>();
        }

        public Folder(T value) {
            super(value);
            this.nodes = new ArrayList<Node>();
        }

        public Node getNodeAt(int index) {
            return this.nodes.get(index);
        }

        public void insertNode(Node node, int index) {
            this.nodes.add(index, node);
        }

        public void appendNode(Node node) {
            this.nodes.add(node);
        }

        public Folder createFolder(T value) {
            Folder f = new Folder(value);
            this.nodes.add(f);
            return f;
        }

        public Leaf createLeaf(T value) {
            Leaf l = new Leaf(value);
            this.nodes.add(l);
            return l;
        }

        public Link createLink(Node node) {
            Link l = new Link(node);
            this.nodes.add(l);
            return l;
        }

        public int getNodeCount() {
            return this.nodes.size();
        }

        public Iterator<Node> iterateNodes() {
            return this.nodes.iterator();
        }

        @Override
        public String toString(String indent, boolean last) {
            String s = indent + "+ " + this.value;
            String tab = indent + (last ? "  " : "| ");
            for (int i = 0; i < this.nodes.size(); ++i) {
                s = s + "\n" + this.nodes.get(i).toString(tab, i + 1 == this.nodes.size());
            }
            return s;
        }
    }

    public class Leaf
    extends Node {
        public Leaf(T value) {
            super(value);
        }

        @Override
        public String toString(String indent, boolean last) {
            return indent + "- " + this.value;
        }
    }

    public abstract class Node {
        protected T value;

        public Node() {
            this(null);
        }

        public abstract String toString(String var1, boolean var2);

        public Node(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

