/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.datatypes;

import java.util.Hashtable;
import java.util.NoSuchElementException;

public class ConnectedList<T> {
    protected boolean ringconnect;
    protected Hashtable<T, Element<T>> elements = new Hashtable();

    public ConnectedList() {
        this(false);
    }

    public ConnectedList(boolean ringconnect) {
        this.ringconnect = ringconnect;
    }

    public T getNext(T element) {
        T result = null;
        Element<T> loc = this.elements.get(element);
        if (loc != null && loc.next != null) {
            result = (T)loc.next.element;
        }
        return result;
    }

    public T getPrev(T element) {
        T result = null;
        Element<T> loc = this.elements.get(element);
        if (loc != null && loc.prev != null) {
            result = (T)loc.prev.element;
        }
        return result;
    }

    public void remove(T element) {
        Element<T> loc = this.elements.get(element);
        if (loc != null) {
            if (loc.prev != null) {
                loc.prev.next = loc.next;
            }
            if (loc.next != null) {
                loc.next.prev = loc.prev;
            }
            this.elements.remove(element);
        }
    }

    public void insert(T element, T neighbour, boolean after) {
        Element<Object> loc = this.elements.get(element);
        if (loc == null) {
            loc = new Element();
            loc.element = element;
            if (this.elements.size() == 0) {
                if (this.ringconnect) {
                    loc.next = loc;
                    loc.prev = loc;
                }
            } else {
                Element<T> loc2 = this.elements.get(neighbour);
                if (loc2 != null) {
                    if (after) {
                        loc.next = loc2.next;
                        loc.prev = loc2;
                        loc2.next = loc;
                    } else {
                        loc.prev = loc2.prev;
                        loc.next = loc2;
                        loc2.prev = loc;
                    }
                    this.elements.put(element, loc);
                } else {
                    throw new NoSuchElementException("Neighbour element does not exist");
                }
            }
        }
    }

    protected class Element<T2> {
        protected T2 element;
        protected Element<T2> next;
        protected Element<T2> prev;

        protected Element() {
        }
    }
}

