/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.ktde.util.ElementConstraint;
import org.ktde.util.cache.Cache;

public class TwoLevelCache<C, S, T> {
    private Hashtable<C, Cache<S, T>> subcaches = new Hashtable();

    public synchronized Cache<S, T> getCache(C parent) {
        Cache<S, T> cache = this.subcaches.get(parent);
        if (cache == null) {
            cache = new Cache();
            this.subcaches.put(parent, cache);
        }
        return cache;
    }

    public synchronized void removeInstance(C parent, S id) {
        Cache<S, T> cache = this.subcaches.get(parent);
        if (cache != null) {
            cache.removeInstance(id);
        }
    }

    public synchronized T getInstance(C parent, S id) {
        Cache<S, T> subcache = this.getCache(parent);
        return subcache.getInstance(id);
    }

    public synchronized void setInstance(C parent, S id, T instance) {
        this.setInstance(parent, id, instance, true);
    }

    public synchronized void setInstance(C parent, S id, T instance, boolean soft) {
        Cache<S, T> subcache = this.getCache(parent);
        subcache.setInstance(id, instance, soft);
    }

    public synchronized Collection<C> getAllKeys() {
        return this.subcaches.keySet();
    }

    public synchronized Map<C, Collection<? extends T>> getAllInstances() {
        return this.getAllInstances((ElementConstraint)null);
    }

    public synchronized Map<C, Collection<? extends T>> getAllInstances(ElementConstraint<T> constraint) {
        HashMap<C, Collection<T>> map = new HashMap<C, Collection<T>>();
        for (C c : this.subcaches.keySet()) {
            Collection<T> allInstances = this.getAllInstances(c, constraint);
            if (allInstances.isEmpty()) continue;
            map.put(c, allInstances);
        }
        return map;
    }

    public synchronized Collection<? extends T> getAllInstances(C c) {
        return this.getAllInstances(c, null);
    }

    public synchronized Collection<? extends T> getAllInstances(C c, ElementConstraint<T> constraint) {
        Cache<S, T> cache = this.subcaches.get(c);
        Set emptySet = Collections.emptySet();
        return cache == null ? emptySet : cache.getAllInstances(constraint);
    }
}

