/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import org.ktde.util.ElementConstraint;

public class Cache<S, T> {
    private IdentityHashMap<Reference<T>, S> ids;
    private Hashtable<S, Reference<T>> instances;
    private ReferenceQueue<T> referenceQueue;

    public Cache() {
        this.ids = new IdentityHashMap();
        this.instances = new Hashtable();
        this.referenceQueue = new ReferenceQueue();
    }

    public Cache(int initialCapacity) {
        this.ids = new IdentityHashMap(initialCapacity);
        this.instances = new Hashtable(initialCapacity);
    }

    public synchronized T getInstance(S id) {
        this.cleanup();
        Reference<T> ref = this.instances.get(id);
        return ref == null ? null : (T)ref.get();
    }

    public synchronized void setInstance(S id, T instance) {
        this.setInstance(id, instance, true);
    }

    public synchronized void removeInstance(S id) {
        Reference<T> ref = this.instances.get(id);
        if (ref != null) {
            this.ids.remove(ref);
            this.instances.remove(id);
        }
    }

    public synchronized void setInstance(S id, T instance, boolean soft) {
        this.cleanup();
        Reference ref = this.instances.get(id);
        if (ref != null) {
            this.ids.remove(ref);
        }
        ref = soft ? new SoftReference<T>(instance, this.referenceQueue) : new WeakReference<T>(instance, this.referenceQueue);
        this.instances.put(id, ref);
        this.ids.put(ref, id);
    }

    public synchronized void cleanup() {
        Reference<T> ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            S id = this.ids.get(ref);
            if (id != null) {
                this.instances.remove(id);
            }
            this.ids.remove(ref);
        }
    }

    public int size() {
        return this.instances.size();
    }

    public Collection<T> getAllInstances() {
        return this.getAllInstances(null);
    }

    public Collection<T> getAllInstances(final ElementConstraint<T> additionalConstraint) {
        ElementConstraint<T> constraint = additionalConstraint != null ? new ElementConstraint<T>(){

            @Override
            public boolean checkConstraint(T t) {
                return t != null && additionalConstraint.checkConstraint(t);
            }
        } : new ElementConstraint<T>(){

            @Override
            public boolean checkConstraint(T t) {
                return t != null;
            }
        };
        this.cleanup();
        Collection<Reference<T>> values = this.instances.values();
        HashSet<T> set = new HashSet<T>();
        for (Reference<T> ref : values) {
            T t;
            if (ref == null || !constraint.checkConstraint(t = ref.get())) continue;
            set.add(t);
        }
        return set;
    }
}

