/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.application;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.ktde.util.StringUtil;
import org.ktde.util.application.LoadSystemDefaultProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientApplicationProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientApplicationProperties.class);
    public static final int SYSTEM_PROPERTIES_MODE_NEVER = 0;
    public static final int SYSTEM_PROPERTIES_MODE_FALLBACK = 1;
    public static final int SYSTEM_PROPERTIES_MODE_OVERRIDE = 2;
    public static String specificFilename;
    private static Map<String, File> propBaseFile;

    public static void setSpecificFileName(String fileName) {
        specificFilename = fileName;
    }

    public static Properties loadProperties(File propertiesFile, File defaultFile, InputStream internalDefaults) throws IOException {
        return ClientApplicationProperties.loadProperties(propertiesFile, defaultFile, internalDefaults, "UTF-8", 2, "", null);
    }

    public static Properties loadProperties(File propertiesFile, File defaultFile, InputStream internalDefaults, String encoding, int overrideMode, String systemPrefix, Properties parent) throws IOException {
        InputStreamReader reader;
        InputStream in;
        if (internalDefaults != null) {
            in = internalDefaults;
            parent = new Properties(parent);
            reader = new InputStreamReader(in, encoding);
            parent.load(reader);
            ((Reader)reader).close();
        }
        LOGGER.debug("Check default: " + defaultFile);
        if (defaultFile != null && defaultFile.exists()) {
            LOGGER.info("load default properties from " + defaultFile);
            in = new FileInputStream(defaultFile);
            parent = new Properties(parent);
            reader = new InputStreamReader(in, encoding);
            parent.load(reader);
            ((Reader)reader).close();
        } else if (defaultFile != null) {
            LOGGER.info("defaults file " + defaultFile + " doesn't exist");
        }
        LOGGER.debug("Check specific property file: " + propertiesFile);
        Properties properties = null;
        if (propertiesFile != null && propertiesFile.exists()) {
            LOGGER.info("load specific properties from " + propertiesFile);
            in = new FileInputStream(propertiesFile);
            InputStreamReader reader2 = new InputStreamReader(in, encoding);
            properties = overrideMode != 0 ? new LoadSystemDefaultProperties(parent, overrideMode == 2, systemPrefix) : new Properties(parent);
            properties.load(reader2);
            ((Reader)reader2).close();
        } else {
            if (propertiesFile != null) {
                LOGGER.info("specific file " + propertiesFile + " doesn't exist");
            }
            properties = overrideMode != 0 ? new LoadSystemDefaultProperties(parent, overrideMode == 2, systemPrefix) : new Properties(parent);
        }
        return properties;
    }

    public static Properties loadProperties(String applicationName, InputStream internalDefaults, String fileEncoding, int systemPropertiesMode, String systemPrefix, Properties parent) throws IOException {
        File propbase = ClientApplicationProperties.getPropBase(applicationName);
        File defaultFile = new File(propbase, "default.properties");
        File propsFile = ClientApplicationProperties.getSpecificFile(applicationName);
        return ClientApplicationProperties.loadProperties(propsFile, defaultFile, internalDefaults, fileEncoding, systemPropertiesMode, systemPrefix, parent);
    }

    public static File getSpecificFile(String applicationName) {
        File propbase = ClientApplicationProperties.getPropBase(applicationName);
        File propsFile = null;
        String specificFile = System.getProperty("application.properties.propertiesFile");
        if (StringUtil.isBlank(specificFile)) {
            specificFile = specificFilename;
        }
        if (!StringUtil.isBlank(specificFile)) {
            propsFile = new File(propbase, specificFile + ".properties");
        }
        return propsFile;
    }

    public static File getPropBase(String applicationName) {
        File file = propBaseFile.get(applicationName);
        if (file == null) {
            String overrideAppname = System.getProperty("application.properties.applicationName", applicationName);
            String propbase = System.getProperty("application.properties.baseDir");
            if (StringUtil.isBlank(propbase)) {
                String rootdir = System.getProperty("root.env.dir");
                propbase = StringUtil.isBlank(rootdir) ? System.getProperty("user.home") + "/." + overrideAppname : rootdir + "/etc/" + overrideAppname;
            }
            file = new File(propbase);
            propBaseFile.put(applicationName, file);
        }
        return file;
    }

    public static Properties loadProperties(String applicationName, InputStream internalDefaults, String systemPrefix) throws IOException {
        return ClientApplicationProperties.loadProperties(applicationName, internalDefaults, "UTF-8", 2, systemPrefix, null);
    }

    public static Properties loadProperties(String applicationName, String systemPrefix) throws IOException {
        return ClientApplicationProperties.loadProperties(applicationName, null, "UTF-8", 2, systemPrefix, null);
    }

    public static Properties loadProperties(String applicationName, InputStream internalDefaults) throws IOException {
        return ClientApplicationProperties.loadProperties(applicationName, internalDefaults, "UTF-8", 2, null, null);
    }

    public static Properties loadProperties(String applicationName) throws IOException {
        return ClientApplicationProperties.loadProperties(applicationName, null, "UTF-8", 2, null, null);
    }

    public static boolean setupProperties(String applicationName, String questionText, String dirNotFoundText, String error) {
        String specificFile = System.getProperty("application.properties.propertiesFile");
        if (specificFile == null) {
            Object[] files;
            File propbase = ClientApplicationProperties.getPropBase(applicationName);
            if (!propbase.exists() || !propbase.isDirectory()) {
                JOptionPane.showMessageDialog(null, propbase.getAbsolutePath() + " does not exist or is not a directory", "Error", 0);
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(1);
                int d = fileChooser.showOpenDialog(null);
                if (d == 0) {
                    propbase = fileChooser.getSelectedFile();
                } else {
                    return false;
                }
            }
            if ((files = propbase.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String name = file.getName();
                    return file.isFile() && name.endsWith(".properties") && !name.equals("default.properties") && !name.equals("dynamic.properties");
                }
            })) == null) {
                JOptionPane.showMessageDialog(null, dirNotFoundText + " (" + propbase.getAbsolutePath() + ")", error, 0);
                return false;
            }
            Arrays.sort(files);
            if (files.length > 0) {
                if (files.length == 1) {
                    Object file = files[0];
                    String name = ClientApplicationProperties.getPropertyName((File)file);
                    System.setProperty("application.properties.propertiesFile", name);
                } else {
                    String[] names = new String[files.length];
                    for (int i = 0; i < files.length; ++i) {
                        String name;
                        Object file = files[i];
                        Properties props = new Properties();
                        try {
                            props.load(new FileInputStream((File)file));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        names[i] = name = props.getProperty("properties.name", ClientApplicationProperties.getPropertyName((File)file));
                    }
                    JComboBox<String> propBox = new JComboBox<String>(names);
                    int d = JOptionPane.showConfirmDialog(null, propBox, questionText, 2, 3);
                    if (d == 0) {
                        System.setProperty("application.properties.propertiesFile", ClientApplicationProperties.getPropertyName((File)files[propBox.getSelectedIndex()]));
                    } else {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static String getPropertyName(File file) {
        String name = file.getName();
        name = name.substring(0, name.length() - 11);
        return name;
    }

    static {
        propBaseFile = new HashMap<String, File>(1);
    }
}

