/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.ktde.util.NameGenerator;
import org.ktde.util.ToStringNameGenerator;
import org.ktde.util.datatypes.Tupel;

public final class StringUtil {
    private static final String SPECIAL_CHARACTER_RESOURCE = "special-character-replacements.txt";
    private static final Pattern STREET_PATTERN;
    private static Map<Character, String> specialCharacterMap;
    private static final char[] RANDOM_CHARS;

    private StringUtil() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String trim(String s) {
        return s == null ? "" : s.trim();
    }

    public static boolean isTrue(String s) {
        boolean result = false;
        if (!StringUtil.isBlank(s)) {
            char c = Character.toLowerCase(s.trim().charAt(0));
            switch (c) {
                case '1': 
                case 'j': 
                case 't': 
                case 'w': 
                case 'x': 
                case 'y': {
                    result = true;
                }
            }
        }
        return result;
    }

    public static String secureSubstring(String s, int beginIndex) {
        if (s == null) {
            return "";
        }
        return StringUtil.secureSubstring(s, beginIndex, s.length());
    }

    public static String secureSubstring(String s, int beginIndex, int endIndex) {
        if (s == null) {
            return "";
        }
        int length = s.length();
        if (beginIndex < 0) {
            beginIndex = length - beginIndex;
        }
        if (endIndex < 0) {
            endIndex = length - endIndex;
        }
        if (endIndex > length) {
            endIndex = length;
        }
        if (beginIndex > endIndex) {
            return "";
        }
        return s.substring(beginIndex, endIndex);
    }

    public static String implode(Object[] os, String glue) {
        if (os == null) {
            os = new Object[]{};
        }
        return StringUtil.implode(os, glue, 0, os.length);
    }

    public static String implode(Object[] os, String glue, int startIndex, int length) {
        Object[] subArray;
        if (os == null) {
            os = new Object[]{};
        }
        if (startIndex != 0 || length != os.length) {
            subArray = new Object[length];
            System.arraycopy(os, startIndex, subArray, 0, length);
        } else {
            subArray = os;
        }
        String result = null;
        if (subArray.length == 0) {
            result = "";
        } else {
            StringBuilder sb = new StringBuilder().append(subArray[0]);
            for (int i = 1; i < subArray.length; ++i) {
                sb.append(glue).append(subArray[i]);
            }
            result = sb.toString();
        }
        return result;
    }

    public static String implode(long[] longs, String glue) {
        String result = null;
        if (longs.length == 0) {
            result = "";
        } else {
            result = "" + longs[0];
            for (int i = 1; i < longs.length; ++i) {
                result = result + glue + longs[i];
            }
        }
        return result;
    }

    public static String implode(int[] ints, String glue) {
        String result = null;
        if (ints.length == 0) {
            result = "";
        } else {
            result = "" + ints[0];
            for (int i = 1; i < ints.length; ++i) {
                result = result + glue + ints[i];
            }
        }
        return result;
    }

    public static <T> String implode(Iterable<T> iter, String glue) {
        return StringUtil.implode(iter, glue, new ToStringNameGenerator());
    }

    public static <T> String implode(T[] regs, String glue, NameGenerator<T> nameGenerator) {
        List<T> list = Arrays.asList(regs);
        return StringUtil.implode(list, glue, nameGenerator);
    }

    public static <T> String implode(Iterable<T> iter, String glue, NameGenerator<T> nameGenerator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T t : iter) {
            if (first) {
                sb.append(nameGenerator.getName(t));
                first = false;
                continue;
            }
            sb.append(glue).append(nameGenerator.getName(t));
        }
        return sb.toString();
    }

    public static <T> String implodeAndTruncate(Iterable<T> iter, String glue, int truncationTriggerLength, NameGenerator<T> nameGenerator) {
        String result = StringUtil.implode(iter, glue, nameGenerator);
        if (result.length() > truncationTriggerLength) {
            result = StringUtil.secureSubstring(result, 0, Math.max(truncationTriggerLength, result.indexOf(glue, truncationTriggerLength) + glue.length()));
            result = result + "...";
        }
        return result;
    }

    public static <T> List<List<T>> createBuckets(List<T> objects, int minInBucket, int maxInBucket) {
        if (objects.isEmpty()) {
            return new ArrayList<List<T>>();
        }
        Hashtable<String, ArrayList<T>> hash = new Hashtable<String, ArrayList<T>>();
        ArrayList<String> strings = new ArrayList<String>();
        for (T t : objects) {
            String s = t.toString();
            strings.add(s);
            ArrayList<T> list = (ArrayList<T>)hash.get(s);
            if (list == null) {
                list = new ArrayList<T>();
                hash.put(s, list);
            }
            list.add(t);
        }
        List<List<String>> buckets = StringUtil.createBuckets(strings, minInBucket, maxInBucket, 1);
        ArrayList<List<T>> result = new ArrayList<List<T>>(buckets.size());
        for (List<String> stringbucket : buckets) {
            ArrayList objectbucket = new ArrayList(stringbucket.size());
            for (String s : stringbucket) {
                List list = (List)hash.get(s);
                objectbucket.add(list.remove(0));
            }
            result.add(objectbucket);
        }
        return result;
    }

    public static List<List<String>> createBuckets(List<String> strings, int minInBucket, int maxInBucket, int chars) {
        Collections.sort(strings);
        ArrayList buckets = new ArrayList();
        ArrayList<String> curbucket = null;
        String cursig = "";
        for (String string : strings) {
            String string2;
            String string3 = string2 = string.length() < chars ? string : string.substring(0, chars);
            if (!string2.equals(cursig)) {
                cursig = string2;
                curbucket = new ArrayList<String>();
                buckets.add(curbucket);
            }
            curbucket.add(string);
        }
        Hashtable<Integer, Integer> sizes = new Hashtable<Integer, Integer>();
        for (List list : buckets) {
            int n = list.size();
            if (n >= minInBucket) continue;
            sizes.put(n, n);
        }
        while (!sizes.isEmpty()) {
            Collection collection = sizes.values();
            Object[] objectArray = new Integer[collection.size()];
            collection.toArray(objectArray);
            Arrays.sort(objectArray);
            int n = (Integer)objectArray[0];
            if (n >= maxInBucket) break;
            sizes.remove(n);
            int sizeBefore = Integer.MAX_VALUE;
            int size = ((List)buckets.get(0)).size();
            int i = 0;
            while (i + 1 < buckets.size()) {
                int sizeAfter = ((List)buckets.get(i + 1)).size();
                if (size == n && (n < minInBucket || n + Math.min(sizeAfter, sizeBefore) <= maxInBucket)) {
                    if (sizeAfter < sizeBefore) {
                        ((List)buckets.get(i)).addAll((Collection)buckets.get(i + 1));
                        buckets.remove(i + 1);
                        sizes.put(size += sizeAfter, size);
                        if (i + 1 < buckets.size()) {
                            sizeAfter = ((List)buckets.get(i + 1)).size();
                        }
                    } else {
                        ((List)buckets.get(i - 1)).addAll((Collection)buckets.get(i));
                        buckets.remove(i);
                        sizes.put(size += sizeBefore, size);
                        sizeBefore = --i > 0 ? ((List)buckets.get(0)).size() : Integer.MAX_VALUE;
                    }
                }
                sizeBefore = size;
                size = sizeAfter;
                ++i;
            }
        }
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        for (List list : buckets) {
            if (list.size() > maxInBucket) {
                arrayList.addAll(StringUtil.createBuckets(list, minInBucket, maxInBucket, chars + 1));
                continue;
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    public static Tupel<String, String> diffSig(String a, String b) {
        String sb;
        int l;
        String sa;
        String ra = "";
        String rb = "";
        if (a.equals(b)) {
            ra = a;
            rb = b;
        }
        if ((sa = a.substring(0, l = Math.min(a.length(), b.length()))).equals(sb = b.substring(0, l))) {
            if (a.length() < b.length()) {
                ra = sa;
                rb = b.substring(0, l + 1);
            } else {
                ra = a.substring(0, l + 1);
                rb = sb;
            }
        } else {
            int i = 0;
            char[] ca = sa.toCharArray();
            char[] cb = sb.toCharArray();
            for (i = 0; i < l && ca[i] == cb[i]; ++i) {
            }
            ra = sa.substring(0, i + 1);
            rb = sb.substring(0, i + 1);
        }
        return new Tupel<String, String>(ra, rb);
    }

    public static Tupel<String, String> fillSig(String a, String b) {
        String sb;
        int l;
        String sa;
        String ra = "";
        String rb = "";
        ra = a;
        rb = b;
        if (!a.equals(b) && (sa = a.substring(0, l = Math.min(a.length(), b.length()))).equals(sb = b.substring(0, l))) {
            if (a.length() < b.length()) {
                char[] filler = new char[b.length() - a.length()];
                Arrays.fill(filler, 'a');
                ra = ra + new String(filler);
            } else {
                char[] filler = new char[a.length() - b.length()];
                Arrays.fill(filler, 'z');
                rb = rb + new String(filler);
            }
        }
        return new Tupel<String, String>(ra, rb);
    }

    public static <T> List<Tupel<String, String>> bucketSigs(List<List<T>> buckets) {
        return StringUtil.bucketSigs(buckets, true);
    }

    public static <T> List<Tupel<String, String>> bucketSigs(List<List<T>> buckets, boolean aToZ) {
        ArrayList<Tupel<String, String>> result = new ArrayList<Tupel<String, String>>();
        if (!buckets.isEmpty()) {
            Tupel cur;
            int i;
            for (List<T> t : buckets) {
                String s1 = t.get(0).toString();
                String s2 = t.get(t.size() - 1).toString();
                result.add(new Tupel<String, String>(s1, s2));
            }
            Tupel last = (Tupel)result.get(0);
            if (aToZ) {
                last.setElement1("A");
            }
            for (i = 1; i < result.size(); ++i) {
                cur = (Tupel)result.get(i);
                Tupel<String, String> sig = StringUtil.diffSig((String)last.getElement2(), (String)cur.getElement1());
                last.setElement2(sig.getElement1());
                cur.setElement1(sig.getElement2());
                last = cur;
            }
            if (aToZ) {
                last.setElement2("Z");
            }
            for (i = 0; i < result.size(); ++i) {
                cur = (Tupel)result.get(i);
                Tupel<String, String> filled = StringUtil.fillSig((String)cur.getElement1(), (String)cur.getElement2());
                result.set(i, filled);
            }
        }
        return result;
    }

    public static String getPhoneticsDe(String s) {
        String[] mappings = new String[]{"ar", "a", "air", "aia", "ayr", "aia", "a", "a", "br", "pr", "b", "p", "ch", "k", "c", "k", "dr", "tr", "d", "t", "er", "a", "eir", "aia", "eyr", "aia", "ei", "ai", "ey", "ai", "e", "e", "f", "f", "g", "k", "h", "", "i", "i", "j", "i", "k", "k", "l", "l", "m", "m", "n", "n", "o", "u", "pr", "pr", "ph", "f", "p", "p", "qu", "k", "q", "k", "r", "", "\u00df", "s", "sch", "j", "str", "jtr", "spr", "jpr", "st", "jt", "sp", "jp", "s", "s", "tr", "tr", "ts", "s", "tz", "s", "t", "t", "u", "u", "v", "f", "w", "f", "x", "s", "y", "i", "z", "s"};
        int len = s.length();
        StringBuffer sb = new StringBuffer(len);
        s = s.toLowerCase();
        block0: for (int i = 0; i < len; ++i) {
            for (int k = 0; k < mappings.length; k += 2) {
                if (!s.startsWith(mappings[k])) continue;
                int klen = mappings[k].length();
                s = s.substring(klen);
                i += klen - 1;
                sb.append(mappings[k + 1]);
                continue block0;
            }
        }
        char[] chars = sb.toString().toCharArray();
        sb.setLength(0);
        char lastchar = '\u0000';
        for (char c : chars) {
            if (c == lastchar) continue;
            lastchar = c;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String multiply(String string, int times) {
        return StringUtil.multiply(string, times, "");
    }

    public static String multiply(String string, int times, String separator) {
        if (times < 0) {
            throw new IllegalArgumentException(times + " is no valid string multiplicator");
        }
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        if (times == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(string);
        for (int i = 1; i < times; ++i) {
            sb.append(separator).append(string);
        }
        return sb.toString();
    }

    private static Map<Character, String> getSpecialCharacterReplacements() {
        if (specialCharacterMap == null) {
            StringUtil.initializeSpecialCharacterReplacements();
        }
        return specialCharacterMap;
    }

    private static void initializeSpecialCharacterReplacements() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(StringUtil.class.getResourceAsStream(SPECIAL_CHARACTER_RESOURCE), "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                if (!StringUtil.isBlank(line)) {
                    StringTokenizer st = new StringTokenizer(line.trim());
                    String chars = st.nextToken();
                    String replacement = st.nextToken();
                    for (int i = 0; i < chars.length(); ++i) {
                        map.put(Character.valueOf(chars.charAt(i)), replacement);
                    }
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        specialCharacterMap = Collections.unmodifiableMap(map);
    }

    public static String normalize(String input) {
        Map<Character, String> map = Collections.emptyMap();
        return StringUtil.normalize(input, map);
    }

    public static String normalize(String input, boolean removeNonCharacters) {
        Map<Character, String> map = Collections.emptyMap();
        return StringUtil.normalize(input, map, removeNonCharacters);
    }

    public static String normalize(String input, Map<Character, String> overridingCharacterReplacements) {
        return StringUtil.normalize(input, overridingCharacterReplacements, true);
    }

    public static String normalize(String input, Map<Character, String> overridingCharacterReplacements, boolean removeNonCharacters) {
        if (input == null) {
            return null;
        }
        String output = input.trim().toLowerCase();
        StringBuilder sb = new StringBuilder();
        Map<Character, String> map = StringUtil.getSpecialCharacterReplacements();
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            String toAppend = overridingCharacterReplacements.get(Character.valueOf(c));
            if (toAppend == null) {
                toAppend = map.get(Character.valueOf(c));
            }
            if (toAppend == null) {
                sb.append(c);
                continue;
            }
            sb.append(toAppend);
        }
        String result = sb.toString();
        return removeNonCharacters ? result.replaceAll("[^a-z0-9]", "") : result;
    }

    public static int getLexicalDistance(char c1, char c2) {
        int cl1 = StringUtil.getLexicalValue(c1);
        int cl2 = StringUtil.getLexicalValue(c2);
        return Math.abs(cl1 - cl2);
    }

    private static int getLexicalValue(char c) {
        int cl = Character.toLowerCase(c);
        if (cl >= 97 && cl <= 122) {
            cl -= 87;
        } else if (cl >= 48 && cl <= 57) {
            cl -= 48;
        } else {
            throw new IllegalArgumentException("Char may only be 0-9a-zA-z");
        }
        return cl;
    }

    public static Set<String> degenerateTokens(List<String> input) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < input.size(); ++i) {
            StringUtil.degenerateTokensRek(input, i, set, i);
        }
        return set;
    }

    private static void degenerateTokensRek(List<String> input, int index, Set<String> set, int sIndex) {
        if (index == input.size() - 1) {
            set.add(StringUtils.join(input.toArray(), "", sIndex, input.size()));
        } else {
            StringUtil.degenerateTokensRek(input, index + 1, set, sIndex);
            String origValue = input.get(index);
            input.set(index, Character.toString(origValue.charAt(0)));
            StringUtil.degenerateTokensRek(input, index + 1, set, sIndex);
            input.set(index, origValue);
        }
    }

    public static List<String> splitWithoutEmptyElements(String string, String regex) {
        String[] parts = string.split(regex);
        ArrayList<String> result = new ArrayList<String>(parts.length);
        for (String s : parts) {
            if (StringUtil.isEmpty(s)) continue;
            result.add(s);
        }
        return result;
    }

    public static String toHexString(byte[] bytes) {
        return StringUtil.toHexString(bytes, 0);
    }

    public static String toHexString(byte[] bytes, int stringlength) {
        StringBuilder builder = new StringBuilder();
        int length = bytes.length;
        if (length * 2 < stringlength) {
            char[] pads = new char[stringlength - length * 2];
            Arrays.fill(pads, '0');
            builder.append(pads);
        }
        for (int i = 0; i < length; ++i) {
            if (bytes[i] <= 15 && bytes[i] >= 0) {
                builder.append("0");
            }
            builder.append(Integer.toHexString(0xFF & bytes[i]));
        }
        return builder.toString();
    }

    public static String getDigestString(String algorithm, String text) throws NoSuchAlgorithmException {
        byte[] bytes = null;
        try {
            bytes = text.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return StringUtil.getDigestString(algorithm, bytes);
    }

    public static String getDigestString(String algorithm, byte[] bytes) throws NoSuchAlgorithmException {
        return StringUtil.getDigestString(algorithm, 32, bytes, 0, bytes.length);
    }

    public static String getMd5String(char[] chars) {
        return StringUtil.getMd5String(String.valueOf(chars));
    }

    public static String getMd5String(byte[] bytes) {
        try {
            return StringUtil.getDigestString("md5", bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMd5String(String text) {
        try {
            return StringUtil.getDigestString("md5", text);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDigestString(String algorithm, byte[] bytes, int offset, int length) throws NoSuchAlgorithmException {
        return StringUtil.getDigestString(algorithm, 32, bytes, offset, length);
    }

    public static String getDigestString(String algorithm, int stringlength, byte[] bytes, int offset, int length) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.reset();
        md.update(bytes, offset, length);
        String mdString = StringUtil.toHexString(md.digest(), stringlength);
        return mdString;
    }

    public static String getLength32(byte[] bytes, int offset, int length) {
        return StringUtil.getChecksumString(new Checksum(){
            private long length = 0L;

            @Override
            public void update(byte[] b, int off, int len) {
                this.length += (long)len;
            }

            @Override
            public void update(int b) {
                ++this.length;
            }

            @Override
            public void reset() {
                this.length = 0L;
            }

            @Override
            public long getValue() {
                return this.length & 0xFFFFFFFFL;
            }
        }, bytes, offset, length);
    }

    public static String getAdler32(byte[] bytes, int offset, int length) {
        return StringUtil.getChecksumString(new Adler32(), bytes, offset, length);
    }

    public static String getCrc32(byte[] bytes, int offset, int length) {
        return StringUtil.getChecksumString(new CRC32(), bytes, offset, length);
    }

    private static String getChecksumString(Checksum checksum, byte[] bytes, int offset, int length) {
        checksum.reset();
        checksum.update(bytes, offset, length);
        String s = Long.toHexString(checksum.getValue());
        StringBuilder builder = new StringBuilder();
        if (s.length() < 16) {
            char[] pads = new char[16 - s.length()];
            Arrays.fill(pads, '0');
            builder.append(pads);
        }
        builder.append(s);
        return builder.toString();
    }

    public static String substringFromBehind(String string, int chars) {
        return string.substring(0, string.length() - chars);
    }

    public static String nullToEmpty(Object object) {
        return object == null ? "" : object.toString();
    }

    public static Set<String> findKeys(String string) {
        List<ReplaceToken> tokens = StringUtil.findReplaceToken(string);
        HashSet<String> keys = new HashSet<String>();
        for (ReplaceToken replaceToken : tokens) {
            if (!(replaceToken instanceof ReplaceVarToken)) continue;
            keys.add(((ReplaceVarToken)replaceToken).key);
        }
        return keys;
    }

    public static String replace(String string, Map<String, String> values) {
        List<ReplaceToken> tokens = StringUtil.findReplaceToken(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (ReplaceToken replaceToken : tokens) {
            if (replaceToken instanceof ReplaceVarToken) {
                String value = values.get(((ReplaceVarToken)replaceToken).key);
                if (value == null) continue;
                stringBuilder.append(value);
                continue;
            }
            stringBuilder.append(((ReplaceTextToken)replaceToken).text);
        }
        return stringBuilder.toString();
    }

    private static List<ReplaceToken> findReplaceToken(String string) {
        LinkedList<ReplaceToken> tokens = new LinkedList<ReplaceToken>();
        ReplaceState state = ReplaceState.TEXT;
        ReplaceTextToken curText = new ReplaceTextToken();
        tokens.add(curText);
        ReplaceVarToken curVar = null;
        block9: for (char c : string.toCharArray()) {
            switch (state) {
                case TEXT: {
                    if (c == '%') {
                        state = ReplaceState.ONE_KEY;
                        continue block9;
                    }
                    curText.text = curText.text + c;
                    continue block9;
                }
                case ONE_KEY: {
                    if (c == '%') {
                        state = ReplaceState.TWO_KEY;
                        continue block9;
                    }
                    curText.text = curText.text + "%" + c;
                    state = ReplaceState.TEXT;
                    continue block9;
                }
                case TWO_KEY: {
                    if (c == '%') {
                        state = ReplaceState.IN_KEYFIRST;
                        continue block9;
                    }
                    curText.text = curText.text + "%%" + c;
                    state = ReplaceState.TEXT;
                    continue block9;
                }
                case IN_KEYFIRST: {
                    if (c == '%') {
                        curText.text = curText.text + "%";
                        continue block9;
                    }
                    curVar = new ReplaceVarToken();
                    curVar.key = "" + c;
                    tokens.add(curVar);
                    state = ReplaceState.IN_KEY;
                    continue block9;
                }
                case IN_KEY: {
                    if (c == '%') {
                        state = ReplaceState.CLOSE_ONE_KEY;
                        continue block9;
                    }
                    curVar.key = curVar.key + c;
                    continue block9;
                }
                case CLOSE_ONE_KEY: {
                    if (c == '%') {
                        state = ReplaceState.CLOSE_TWO_KEY;
                        continue block9;
                    }
                    curVar.key = curVar.key + "%" + c;
                    state = ReplaceState.IN_KEY;
                    continue block9;
                }
                case CLOSE_TWO_KEY: {
                    if (c == '%') {
                        state = ReplaceState.TEXT;
                        curText = new ReplaceTextToken();
                        tokens.add(curText);
                        continue block9;
                    }
                    curVar.key = curVar.key + "%%" + c;
                    state = ReplaceState.IN_KEY;
                }
            }
        }
        return tokens;
    }

    public static String getNotNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String capitalize(String string) {
        if (StringUtil.isBlank(string)) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static Tupel<String, String[]> parseTokens(String string) {
        string = string.trim();
        StringTokenizer st = new StringTokenizer(string, "(");
        String type = st.nextToken().trim();
        LinkedList<String> params = new LinkedList<String>();
        if (st.hasMoreTokens()) {
            String paramsString = st.nextToken().trim();
            if (paramsString.charAt(paramsString.length() - 1) == ')') {
                paramsString = paramsString.substring(0, paramsString.length() - 1);
            }
            StringTokenizer st2 = new StringTokenizer(paramsString, ",");
            while (st2.hasMoreElements()) {
                String param = st2.nextToken();
                params.add(param);
            }
        }
        String[] paramsArray = new String[params.size()];
        return new Tupel<String, String[]>(type, params.toArray(paramsArray));
    }

    public static String whiteSpaceToSingleBlanks(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(string);
        if (!st.hasMoreTokens()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(st.nextToken());
        while (st.hasMoreTokens()) {
            sb.append(" ").append(st.nextToken());
        }
        return sb.toString();
    }

    public static String emptyToNull(String string) {
        return StringUtil.isBlank(string) ? null : string;
    }

    public static String nullSafeToString(Object o) {
        return o == null ? null : o.toString();
    }

    public static StreetSplitResult splitStreetAddress(String street) {
        if (street == null) {
            return null;
        }
        Matcher matcher = STREET_PATTERN.matcher(street);
        if (matcher.matches()) {
            String housenumber1 = matcher.group(2);
            String housenumber2 = matcher.group(4);
            String housenumberExtension2 = StringUtil.nullToEmpty(matcher.group(5)).trim();
            if (StringUtil.isBlank(housenumber2) && !StringUtil.isBlank(housenumberExtension2)) {
                housenumber2 = housenumber1;
            }
            return new StreetSplitResult(matcher.group(1).trim(), StringUtil.isBlank(housenumber1) ? null : Integer.valueOf(housenumber1.trim()), StringUtil.nullToEmpty(matcher.group(3)).trim(), StringUtil.isBlank(housenumber2) ? null : Integer.valueOf(housenumber2.trim()), StringUtil.nullToEmpty(matcher.group(5)).trim());
        }
        return new StreetSplitResult(street.trim(), null, "", null, "");
    }

    public static String deCapitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static String removeNonAsciiChars(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            char code = c;
            if (code < '\u0000' || code >= '\u0080') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String removeNonMatchingChars(String input, boolean keepCharacters, boolean keepDigits, char[] charsToKeep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!(keepCharacters && Character.isLetter(c) || keepDigits && Character.isDigit(c)) && !ArrayUtils.contains(charsToKeep, c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String nullToFallback(Object o, String fallback) {
        return o == null ? fallback : o.toString();
    }

    public static String constantToClassname(String string) {
        StringTokenizer st = new StringTokenizer(string, "_");
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            sb.append(StringUtil.capitalize(st.nextToken().toLowerCase()));
        }
        return sb.toString();
    }

    public static String constantToJavaIdent(String string) {
        String className = StringUtil.constantToClassname(string);
        return Character.toString(className.charAt(0)).toLowerCase() + className.substring(1);
    }

    public static List<String> explode(String string, char separator) {
        LinkedList<String> list = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == separator) {
                list.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String capitalizeAll(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        char c = string.charAt(0);
        boolean letterMode = Character.isLetter(c);
        StringBuilder result = new StringBuilder();
        char first = c;
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            boolean letter = Character.isLetter(c);
            if (letter == letterMode) {
                sb.append(c);
                continue;
            }
            String tail = sb.toString();
            if (letterMode) {
                first = Character.toUpperCase(first);
                tail = tail.toLowerCase();
            }
            result.append(first).append(tail);
            first = c;
            sb = new StringBuilder();
            letterMode = !letterMode;
        }
        String tail = sb.toString();
        if (letterMode) {
            first = Character.toUpperCase(first);
            tail = tail.toLowerCase();
        }
        result.append(first).append(tail);
        return result.toString();
    }

    public static boolean areAllBlank(String ... strings) {
        for (String s : strings) {
            if (StringUtil.isBlank(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAtLeastOneBlank(String ... strings) {
        for (String s : strings) {
            if (!StringUtil.isBlank(s)) continue;
            return true;
        }
        return false;
    }

    public static String removeComments(String string, String opener, String closer) {
        boolean found;
        String r = string;
        do {
            int indexCloser;
            found = false;
            int indexOpener = r.indexOf(opener);
            if (indexOpener < 0 || (indexCloser = r.indexOf(closer, indexOpener + opener.length())) < 0) continue;
            String pre = r.substring(0, indexOpener);
            String succ = r.substring(indexCloser + closer.length(), r.length());
            r = pre + succ;
            found = true;
        } while (found);
        return r;
    }

    public static String removeEndOfLineComments(String string, String opener) {
        String remove = StringUtil.removeComments(string, opener, "\n");
        int index = remove.lastIndexOf(opener);
        if (index >= 0) {
            remove = remove.substring(0, index);
        }
        return remove;
    }

    public static String flatArrayString(String[] strings) {
        if (strings == null) {
            return "0;";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(strings.length);
        sb.append(";");
        for (String string : strings) {
            if (string == null) {
                sb.append("0").append(";").append("");
            }
            sb.append(string.length()).append(";").append(string);
        }
        return sb.toString();
    }

    public static String[] unflatArrayString(String string) {
        if (string == null) {
            return new String[0];
        }
        int index = string.indexOf(59);
        if (index < 0) {
            return new String[0];
        }
        int stringCount = Integer.parseInt(string.substring(0, index));
        String[] array = new String[stringCount];
        ++index;
        for (int i = 0; i < stringCount; ++i) {
            int nIndex = string.indexOf(59, index);
            int sLength = Integer.parseInt(string.substring(index, nIndex));
            index = ++nIndex + sLength;
            array[i] = string.substring(nIndex, index);
        }
        return array;
    }

    public static String getCharacterOnlyRandomString(int length) {
        int i;
        int cLength = 52;
        char[] chars = new char[cLength];
        int count = 0;
        for (i = 97; i <= 122; ++i) {
            chars[count++] = (char)i;
        }
        for (i = 65; i <= 90; ++i) {
            chars[count++] = (char)i;
        }
        return StringUtil.getRandomString(length, chars);
    }

    public static String getRandomString(int length) {
        return StringUtil.getRandomString(length, RANDOM_CHARS);
    }

    public static String getRandomString(int length, char[] chars) {
        StringBuilder sb = new StringBuilder(length);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(chars[random.nextInt(chars.length)]);
        }
        return sb.toString();
    }

    public static String replaceNonLettersAndNonDigits(String input, String replacement) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append(replacement);
        }
        return sb.toString();
    }

    public static String roundDouble(double d, int decimalDigitCount, boolean removeDecimalZeros) {
        double mult = Math.pow(10.0, decimalDigitCount);
        long round = Math.round(d * mult);
        long lMult = (long)mult;
        StringBuilder sb = new StringBuilder(Long.toString(round / lMult));
        long mod = round % lMult;
        String modString = StringUtils.leftPad(Long.toString(mod), decimalDigitCount, '0');
        if (removeDecimalZeros) {
            int index = modString.length();
            for (int i = index - 1; i >= 0; ++i) {
                if (modString.charAt(i) == '0') continue;
                index = i;
                break;
            }
            if ((modString = modString.substring(0, index)).length() > 0) {
                sb.append(".");
            }
        } else {
            sb.append(".");
        }
        sb.append(modString);
        return sb.toString();
    }

    public static int countChar(String string, char c) {
        if (string == null) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String toStringWithCarriageReturn(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        boolean lCr = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    if (!lCr) {
                        sb.append("\r");
                    }
                    lCr = false;
                    break;
                }
                case '\r': {
                    lCr = true;
                    break;
                }
                default: {
                    if (lCr) {
                        sb.append("\n");
                    }
                    lCr = false;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean containsUnmaskedChar(String s, char c, char mask) {
        for (int i = 0; i < s.length(); ++i) {
            char p = s.charAt(i);
            if (p == mask) {
                ++i;
                continue;
            }
            if (p != c) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnmasked(String value, char toReplace, char replacement, char mask) {
        int index;
        StringBuilder sb = new StringBuilder();
        int cIndex = 0;
        do {
            if ((index = value.indexOf(toReplace, cIndex)) >= 0) {
                if (index > 0) {
                    char m = value.charAt(index - 1);
                    if (m == mask) {
                        sb.append(value.substring(cIndex, index - 1)).append(toReplace);
                    } else {
                        sb.append(value.substring(cIndex, index)).append(replacement);
                    }
                } else {
                    sb.append(replacement);
                }
                cIndex = index + 1;
                continue;
            }
            sb.append(value.substring(cIndex, value.length()));
        } while (index >= 0);
        return sb.toString();
    }

    public static List<Chunk> splitInChunks(String s, char[] separator, Character[] masks) {
        int index;
        LinkedList<Chunk> chunks = new LinkedList<Chunk>();
        int cIndex = 0;
        do {
            index = -1;
            int arrayIndex = -1;
            int count = 0;
            for (char sep : separator) {
                int sIndex = s.indexOf(sep, cIndex);
                if (sIndex >= 0 && (index < 0 || sIndex < index)) {
                    index = sIndex;
                    arrayIndex = count;
                }
                ++count;
            }
            Character mask = masks[arrayIndex];
            if (index >= 0) {
                if (mask != null && index > 0) {
                    char m = s.charAt(index - 1);
                    if (Character.valueOf(m).equals(mask)) {
                        String part = s.substring(cIndex, index + 1);
                        chunks.add(new Chunk(part));
                        continue;
                    }
                    chunks.add(new Chunk(s.substring(cIndex, index)));
                    chunks.add(new Chunk(Character.valueOf(s.charAt(index))));
                    continue;
                }
                chunks.add(new Chunk(Character.valueOf(s.charAt(index))));
                continue;
            }
            chunks.add(new Chunk(s.substring(cIndex, s.length())));
        } while (index >= 0);
        if (chunks.size() <= 1) {
            return chunks;
        }
        LinkedList<Chunk> flat = new LinkedList<Chunk>();
        Iterator iter = chunks.iterator();
        Chunk pred = (Chunk)iter.next();
        while (iter.hasNext()) {
            Chunk succ = (Chunk)iter.next();
            if (pred.isSeparator()) {
                flat.add(pred);
                pred = succ;
                continue;
            }
            if (succ.isSeparator()) {
                flat.add(pred);
                pred = succ;
                continue;
            }
            pred = new Chunk(pred.getText() + succ.getText());
        }
        flat.add(pred);
        return flat;
    }

    public static String splitInChunksAndCreateNormalizedString(String s, char[] separator, Character[] masks) {
        List<Chunk> chunks = StringUtil.splitInChunks(s, separator, masks);
        StringBuilder sb = new StringBuilder();
        for (Chunk chunk : chunks) {
            if (chunk.isSeparator()) {
                sb.append(chunk.getSeparator());
                continue;
            }
            sb.append(StringUtil.normalize(chunk.getText()));
        }
        return sb.toString();
    }

    public static String maskChars(String string, char[] chars, char mask) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (ArrayUtils.contains(chars, c)) {
                sb.append(mask);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        int i;
        STREET_PATTERN = Pattern.compile("(\\D+)(\\d*)\\s*([a-zA-Z]*)\\s*(?:(?:-|/)\\s*(\\d*)??\\s*([a-zA-Z]*))??\\s*");
        int length = 64;
        RANDOM_CHARS = new char[length];
        int count = 0;
        for (i = 97; i <= 122; ++i) {
            StringUtil.RANDOM_CHARS[count++] = (char)i;
        }
        for (i = 65; i <= 90; ++i) {
            StringUtil.RANDOM_CHARS[count++] = (char)i;
        }
        StringUtil.RANDOM_CHARS[count++] = 37;
        StringUtil.RANDOM_CHARS[count++] = 33;
        StringUtil.RANDOM_CHARS[count++] = 167;
        StringUtil.RANDOM_CHARS[count++] = 36;
        StringUtil.RANDOM_CHARS[count++] = 38;
        StringUtil.RANDOM_CHARS[count++] = 47;
        StringUtil.RANDOM_CHARS[count++] = 40;
        StringUtil.RANDOM_CHARS[count++] = 41;
        StringUtil.RANDOM_CHARS[count++] = 61;
        StringUtil.RANDOM_CHARS[count++] = 43;
        StringUtil.RANDOM_CHARS[count++] = 45;
        StringUtil.RANDOM_CHARS[count++] = 42;
    }

    public static class Chunk {
        private String text;
        private Character separator;

        public Chunk(String text) {
            this.text = text;
        }

        public Chunk(Character c) {
            this.separator = c;
        }

        public Character getSeparator() {
            return this.separator;
        }

        public String getText() {
            return this.text;
        }

        public boolean isSeparator() {
            return this.separator != null;
        }
    }

    public static class StreetSplitResult {
        private String street;
        private Integer housenumber1;
        private String housenumberExtension1;
        private Integer housenumber2;
        private String housenumberExtension2;

        public StreetSplitResult(String street, Integer housenumber1, String housenumberExtension1, Integer housenumber2, String housenumberExtension2) {
            this.street = street;
            this.housenumber1 = housenumber1;
            this.housenumberExtension1 = housenumberExtension1;
            this.housenumber2 = housenumber2;
            this.housenumberExtension2 = housenumberExtension2;
        }

        public String getStreet() {
            return this.street;
        }

        public Integer getHousenumber1() {
            return this.housenumber1;
        }

        public String getHousenumberExtension1() {
            return this.housenumberExtension1;
        }

        public Integer getHousenumber2() {
            return this.housenumber2;
        }

        public String getHousenumberExtension2() {
            return this.housenumberExtension2;
        }

        public boolean hasHousenumber() {
            return this.getHousenumber1() != null;
        }

        public boolean isRange() {
            return this.getHousenumber2() != null;
        }
    }

    private static enum ReplaceState {
        TEXT,
        ONE_KEY,
        TWO_KEY,
        IN_KEY,
        IN_KEYFIRST,
        CLOSE_ONE_KEY,
        CLOSE_TWO_KEY;

    }

    private static class ReplaceTextToken
    implements ReplaceToken {
        String text = "";

        private ReplaceTextToken() {
        }
    }

    private static class ReplaceVarToken
    implements ReplaceToken {
        String key = "";

        private ReplaceVarToken() {
        }
    }

    private static interface ReplaceToken {
    }
}

