/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util;

import java.util.concurrent.ConcurrentHashMap;

public abstract class MultitonManager<S, T> {
    private ConcurrentHashMap<S, T> instances;
    private T nullInstance = this.createNullInstance();

    public T getInstance(S name) {
        Object instance = null;
        if (this.instances == null) {
            this.instances = new ConcurrentHashMap();
        } else {
            instance = this.instances.get(name);
        }
        if (instance == null) {
            instance = this.createInstance(name);
            if (instance == null) {
                instance = this.nullInstance;
            }
            if (instance != null) {
                this.instances.putIfAbsent(name, instance);
                instance = this.instances.get(name);
            }
        }
        if (instance == this.nullInstance) {
            instance = null;
        }
        return (T)instance;
    }

    protected T createNullInstance() {
        return null;
    }

    protected abstract T createInstance(S var1);
}

