/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataParser {
    public static Number getNumberFromString(String string) throws ParseException {
        Number result = null;
        if ((string = string.trim()).length() > 0) {
            Pattern[] patterns;
            boolean neg = false;
            if (string.charAt(0) == '-') {
                neg = true;
                string = string.substring(1);
            } else if (string.charAt(string.length() - 1) == '-') {
                neg = true;
                string = string.substring(0, string.length() - 1);
            }
            for (Pattern pattern : patterns = new Pattern[]{Pattern.compile("((?:\\d+(?:,\\d\\d\\d)*)?)\\.((?:\\d*)?)"), Pattern.compile("((?:\\d+(?:\\.\\d\\d\\d)*)?),((?:\\d*)?)"), Pattern.compile("((?:\\d+(?:,\\d\\d\\d)*)?)"), Pattern.compile("((?:\\d+(?:\\.\\d\\d\\d)*)?)")}) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                String intpartstring = matcher.group(1).replaceAll("\\.|,", "");
                int intpart = 0;
                if (intpartstring.length() > 0) {
                    intpart = Integer.parseInt(intpartstring, 10);
                }
                String floatpartstring = "";
                int floatpart = 0;
                if (matcher.groupCount() > 1 && (floatpartstring = matcher.group(2)).length() > 0) {
                    floatpart = Integer.parseInt(floatpartstring, 10);
                }
                if (floatpart == 0) {
                    result = neg ? 0 - intpart : intpart;
                    break;
                }
                result = Double.valueOf((neg ? "-" : "") + intpartstring + "." + floatpartstring);
                break;
            }
            if (result == null) {
                throw new ParseException("cannot parse number '" + string + "'", 0);
            }
        }
        return result;
    }

    public static String getStringFromNumber(Number number) {
        return DataParser.getStringFromNumber(number, 2, true, true);
    }

    public static String getStringFromNumber(Number number, int fractions, boolean forceFractions, boolean truncFractions) {
        if (number == null) {
            return "";
        }
        String formatted = number.toString();
        int decpos = formatted.indexOf(46);
        if (decpos == -1) {
            decpos = formatted.length();
            if (forceFractions) {
                formatted = formatted + ".";
            }
        }
        String result = "";
        if (formatted.charAt(0) == '-') {
            formatted = formatted.substring(1);
            result = "-";
            --decpos;
        }
        int over = decpos % 3;
        for (int i = 0; i < decpos; ++i) {
            result = result + formatted.charAt(i);
            if (i + 1 >= decpos || (i + 1) % 3 != over) continue;
            result = result + '.';
        }
        if (decpos < formatted.length()) {
            int i;
            result = result + ",";
            int numfrac = 0;
            for (i = decpos + 1; i < formatted.length(); ++i) {
                result = result + formatted.charAt(i);
                if (truncFractions && ++numfrac == fractions) break;
            }
            if (forceFractions) {
                for (i = numfrac; i < fractions; ++i) {
                    result = result + "0";
                }
            }
        }
        return result;
    }

    public static Date getDateFromString(String string) throws ParseException {
        Date result = null;
        if ((string = string.trim()).length() > 0) {
            Pattern[] patterns = new Pattern[]{Pattern.compile("((?:\\d{2})|(?:\\d{4}))(\\d{2})(\\d{2})"), Pattern.compile("((?:\\d{2})|(?:\\d{4}))-(\\d{1,2})-(\\d{1,2})"), Pattern.compile("(\\d{1,2})/(\\d{1,2})/((?:\\d{2})|(?:\\d{4}))"), Pattern.compile("(\\d{1,2})\\.(\\d{1,2})\\.((?:\\d{2})|(?:\\d{4}))")};
            int cyear = new GregorianCalendar().get(1) - 2000;
            int[] d = new int[]{3, 3, 2, 1};
            int[] m = new int[]{2, 2, 1, 2};
            int[] y = new int[]{1, 1, 3, 3};
            for (int i = 0; i < patterns.length; ++i) {
                Matcher matcher = patterns[i].matcher(string);
                if (!matcher.matches()) continue;
                int day = Integer.parseInt(matcher.group(d[i]), 10);
                int mon = Integer.parseInt(matcher.group(m[i]), 10);
                int yea = Integer.parseInt(matcher.group(y[i]), 10);
                if (yea < 100) {
                    yea = yea <= cyear + 10 ? (yea += 2000) : (yea += 1900);
                }
                result = new GregorianCalendar(yea, mon - 1, day).getTime();
                break;
            }
            if (result == null) {
                throw new ParseException("cannot parse date '" + string + "'", 0);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromDate(Date date) {
        SimpleDateFormat dateFormat;
        String result = "";
        SimpleDateFormat simpleDateFormat = dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        synchronized (simpleDateFormat) {
            if (date != null) {
                result = dateFormat.format(date);
            }
        }
        return result;
    }
}

