/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.QuickMapNavigatorRenderer;

public class WmsClientMapNavigatorRenderer
extends QuickMapNavigatorRenderer {
    private String host;
    private String layers;
    private String styles;
    private String sld;
    private boolean transparent;

    public WmsClientMapNavigatorRenderer(int maxImages, String host, String layers, String styles, String sld, boolean transparent) {
        super("", maxImages);
        this.host = host;
        this.layers = layers;
        this.styles = styles;
        this.sld = sld;
        this.transparent = transparent;
    }

    public String getLayers() {
        return this.layers;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public String getStyles() {
        return this.styles;
    }

    public String getSld() {
        return this.sld;
    }

    @Override
    public String getUrlForCoords(Coordinate bl, Coordinate tr, int imagew, int imageh, CoordinateFactory factory) {
        int left = (int)Math.floor(bl.getX());
        int top = (int)Math.ceil(tr.getY());
        int right = (int)Math.ceil(tr.getX());
        int bottom = (int)Math.floor(bl.getY());
        CoordinateFactory epsgFactory = this.getEpsgFactory(factory);
        Coordinate blr = epsgFactory.createCoordinate(factory.createCoordinate(left, bottom));
        Coordinate trr = epsgFactory.createCoordinate(factory.createCoordinate(right, top));
        String leftS = epsgFactory.getStringX(blr);
        String topS = epsgFactory.getStringY(trr);
        String rightS = epsgFactory.getStringX(trr);
        String bottomS = epsgFactory.getStringY(blr);
        StringBuilder builder = new StringBuilder();
        builder.append("http://");
        builder.append(this.host);
        builder.append("?REQUEST=GetMap&width=" + imagew + "&height=" + imageh);
        builder.append("&format=image/png&version=1.1.1");
        builder.append("&layers=" + this.getLayers());
        builder.append("&styles=" + this.getStyles());
        builder.append("&sld=" + this.getSld());
        builder.append("&srs=EPSG:" + this.getEpsg(factory));
        builder.append("&bbox=" + leftS + "," + bottomS + "," + rightS + "," + topS);
        builder.append("&transparent=" + (this.isTransparent() ? "true" : "false"));
        return builder.toString();
    }

    public CoordinateFactory getEpsgFactory(CoordinateFactory factory) {
        return factory;
    }

    public int getEpsg(CoordinateFactory factory) {
        return factory.getEpsg();
    }
}

