/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JDialog;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;

public class SimpleNavigatorFrame
extends JDialog {
    private static final long serialVersionUID = -8939255379530831343L;
    private NavigatorPanel navigator;

    public SimpleNavigatorFrame(Dialog owner, boolean modal, CoordinateFactory coordinateFactory, Coordinate startCoords, NavigatorRenderer ... renderer) {
        super(owner, modal);
        this.initialize(coordinateFactory, startCoords, renderer);
    }

    public SimpleNavigatorFrame(Dialog owner, String title, boolean modal, CoordinateFactory coordinateFactory, Coordinate startCoords, NavigatorRenderer ... renderer) {
        super(owner, title, modal);
        this.initialize(coordinateFactory, startCoords, renderer);
    }

    public SimpleNavigatorFrame(Frame owner, boolean modal, CoordinateFactory coordinateFactory, Coordinate startCoords, NavigatorRenderer ... renderer) {
        super(owner, modal);
        this.initialize(coordinateFactory, startCoords, renderer);
    }

    public SimpleNavigatorFrame(Frame owner, String title, boolean modal, CoordinateFactory coordinateFactory, Coordinate startCoords, NavigatorRenderer ... renderer) {
        super(owner, title, modal);
        this.initialize(coordinateFactory, startCoords, renderer);
    }

    protected void initialize(CoordinateFactory coordinateFactory, final Coordinate startCoords, NavigatorRenderer ... renderer) {
        this.getContentPane().setLayout(new BorderLayout());
        final Coordinate extStartCoordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        this.setSize(800, 600);
        this.navigator = startCoords != null ? new NavigatorPanel(startCoords, coordinateFactory, this.getParent()) : new NavigatorPanel(extStartCoordinate, coordinateFactory, this.getParent());
        this.navigator.setPanning(true);
        this.getContentPane().add((Component)this.navigator, "Center");
        for (NavigatorRenderer navigatorRenderer : renderer) {
            this.navigator.addRenderer(navigatorRenderer);
        }
        this.addExtraWidgets();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (startCoords != null) {
                    SimpleNavigatorFrame.this.navigator.gotoCoordinate(startCoords);
                } else {
                    SimpleNavigatorFrame.this.navigator.gotoCoordinate(extStartCoordinate);
                }
            }
        }.start();
        this.setVisible(true);
    }

    protected void addExtraWidgets() {
    }

    public void gotoCoordinate(Coordinate c) {
        this.navigator.gotoCoordinate(c);
    }
}

