/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.OsmNavigatorRenderer;

public class OsmNavigatorRendererTest
extends AbstractNavigatorRenderer {
    public static final Coordinate[][] TEST_COORDS = new Coordinate[][]{{Wgs84Factory.INSTANCE.createCoordinate(11.591944, 48.152778), GeoDecimalFactory.INSTANCE.createCoordinate(1337717.0, 5251622.0), Wgs84Factory.INSTANCE.createCoordinate(9.983333, 53.561111), GeoDecimalFactory.INSTANCE.createCoordinate(695815.0, 5094135.0)}, {MercatorFactory.INSTANCE.createCoordinate(600000.0, 5600000.0), MercatorFactory.INSTANCE.createCoordinate(-200000.0, 5600000.0), MercatorFactory.INSTANCE.createCoordinate(-200000.0, 5200000.0), MercatorFactory.INSTANCE.createCoordinate(200000.0, 5200000.0), MercatorFactory.INSTANCE.createCoordinate(200000.0, 6000000.0), MercatorFactory.INSTANCE.createCoordinate(1000000.0, 6000000.0), MercatorFactory.INSTANCE.createCoordinate(1000000.0, 6400000.0), MercatorFactory.INSTANCE.createCoordinate(600000.0, 6400000.0)}, {MercatorFactory.INSTANCE.createCoordinate(1000000.0, 6400000.0), MercatorFactory.INSTANCE.createCoordinate(1400000.0, 6400000.0), MercatorFactory.INSTANCE.createCoordinate(1400000.0, 7200000.0), MercatorFactory.INSTANCE.createCoordinate(2200000.0, 7200000.0), MercatorFactory.INSTANCE.createCoordinate(2200000.0, 7600000.0), MercatorFactory.INSTANCE.createCoordinate(1800000.0, 7600000.0), MercatorFactory.INSTANCE.createCoordinate(1800000.0, 6800000.0), MercatorFactory.INSTANCE.createCoordinate(1000000.0, 6800000.0)}};
    private static AbstractNavigatorRenderer orenderer = new OsmNavigatorRenderer(System.getProperties());
    private static OsmNavigatorRendererTest drenderer = new OsmNavigatorRendererTest();

    public OsmNavigatorRendererTest() {
        super("OsmNavigatorRendererTest");
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        Color[] colors = new Color[]{Color.RED, Color.BLUE, Color.GREEN};
        g2d.setStroke(new BasicStroke((float)(upp * 3.0)));
        CoordinateFactory factory = this.getPanel().getCoordinateFactory();
        for (Coordinate[] element : TEST_COORDS) {
            for (int i = 0; i < element.length; ++i) {
                Coordinate userspace = factory.createCoordinate(element[i]);
                g2d.setColor(Color.WHITE);
                g2d.fill(new Ellipse2D.Double(userspace.getX() - upp * 10.0, userspace.getY() - upp * 10.0, upp * 20.0, upp * 20.0));
                g2d.setColor(Color.BLACK);
                g2d.draw(new Ellipse2D.Double(userspace.getX() - upp * 10.0, userspace.getY() - upp * 10.0, upp * 20.0, upp * 20.0));
            }
        }
        for (int t = 0; t < TEST_COORDS.length; ++t) {
            g2d.setColor(colors[t]);
            for (int i = 0; i < TEST_COORDS[t].length; ++i) {
                Coordinate userspace1 = factory.createCoordinate(TEST_COORDS[t][(i + 1) % TEST_COORDS[t].length]);
                Coordinate userspace2 = factory.createCoordinate(TEST_COORDS[t][i]);
                g2d.drawLine((int)userspace1.getX(), (int)userspace1.getY(), (int)userspace2.getX(), (int)userspace2.getY());
            }
        }
        return Collections.emptyList();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        final NavigatorPanel navigator = new NavigatorPanel(TEST_COORDS[0][0], OpenStreetmapViewFactory.INSTANCE, null);
        navigator.addRenderer(orenderer);
        navigator.addRenderer(drenderer);
        navigator.setPanning(true);
        frame.getContentPane().add((Component)navigator, "Center");
        frame.setSize(800, 600);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                navigator.gotoCoordinate(TEST_COORDS[0][0]);
            }
        }.start();
        frame.setVisible(true);
    }
}

