/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.KeyStroke;
import org.ktde.swing.navigator.AbstractMouseManipulatorAction;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;

public class NavigatorPanningAction
extends AbstractMouseManipulatorAction {
    private static final long serialVersionUID = 1223503441356626868L;
    private Point2D.Double mouseDown;
    private double lastDeltaX;
    private double lastDeltaY;
    private Cursor panningUp;
    private Cursor panningDown;
    private boolean changeCursor;
    private Cursor upCursor;
    private static double[] zoomUpps;

    public NavigatorPanningAction(String title, NavigatorPanel navigatorPanel) {
        this(title, navigatorPanel, true);
    }

    public NavigatorPanningAction(String title, NavigatorPanel navigatorPanel, boolean changeCursor) {
        super(navigatorPanel, null, title);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(119, 0));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(NavigatorPanel.class.getResource("/cursor/handopen.png"));
        this.panningUp = toolkit.createCustomCursor(image, new Point(16, 16), "img");
        image = toolkit.getImage(NavigatorPanel.class.getResource("/cursor/handclosed.png"));
        this.panningDown = toolkit.createCustomCursor(image, new Point(16, 16), "img");
        this.changeCursor = changeCursor;
    }

    @Override
    protected void turnedOff() {
        if (this.changeCursor) {
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected void turnedOn() {
        if (this.changeCursor) {
            this.getNavigatorPanel().setCursor(this.panningUp);
        }
    }

    @Override
    public void mouseDragged(int x, int y) {
        double deltaX = (double)x - this.mouseDown.x;
        double deltaY = (double)y - this.mouseDown.y;
        double translateX = deltaX - this.lastDeltaX;
        double translateY = deltaY - this.lastDeltaY;
        this.getNavigatorPanel().translate(translateX, translateY);
        this.lastDeltaX = deltaX;
        this.lastDeltaY = deltaY;
    }

    @Override
    public void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
        this.mouseDown = new Point2D.Double(x, y);
        this.lastDeltaX = 0.0;
        this.lastDeltaY = 0.0;
        this.upCursor = this.getNavigatorPanel().getCursor();
        this.getNavigatorPanel().setCursor(this.panningDown);
    }

    @Override
    public void mouseDragFinished(int x, int y, int modifiers) {
        this.mouseDown = null;
        if (this.upCursor != null) {
            this.getNavigatorPanel().setCursor(this.upCursor);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.mouseDown == null) {
            NavigatorPanningAction.performWheelZoom(e, this.getNavigatorPanel());
        }
    }

    public static boolean performWheelZoom(MouseWheelEvent e, NavigatorPanel navigatorPanel) {
        if (e.getScrollType() == 0 && (navigatorPanel.getUpp() >= 0.015625 || e.getUnitsToScroll() > 0) && (navigatorPanel.getUpp() <= 16384.0 || e.getUnitsToScroll() < 0)) {
            int unitsToScroll = e.getUnitsToScroll();
            Point2D.Double pixel = new Point2D.Double(e.getX(), e.getY());
            boolean zoomIn = unitsToScroll <= 0;
            NavigatorPanningAction.performZoomStep(navigatorPanel, zoomIn, pixel);
            return true;
        }
        return false;
    }

    public static void performZoomStep(NavigatorPanel navigatorPanel, boolean zoomIn) {
        NavigatorPanningAction.performZoomStep(navigatorPanel, zoomIn, navigatorPanel.getCenterPixel());
    }

    public static void performZoomStep(NavigatorPanel navigatorPanel, boolean zoomIn, Point2D.Double pixel) {
        int zoomInInt;
        int n = zoomInInt = zoomIn ? -1 : 1;
        if (zoomUpps == null) {
            double zoom = Math.pow(2.0, -zoomInInt);
            navigatorPanel.zoom(zoom, pixel);
        } else if (zoomUpps.length > 0) {
            double currentUpp = navigatorPanel.getUpp();
            double pred = zoomUpps[0];
            Integer newZoomIndex = null;
            if (currentUpp <= pred) {
                newZoomIndex = 0;
            } else {
                for (int i = 1; i < zoomUpps.length; ++i) {
                    double next = zoomUpps[i];
                    if (currentUpp <= next) {
                        double distToPred = currentUpp - pred;
                        double distToNext = next - currentUpp;
                        if (distToPred < distToNext) {
                            newZoomIndex = i - 1;
                            break;
                        }
                        newZoomIndex = i;
                        break;
                    }
                    pred = next;
                }
                if (newZoomIndex == null) {
                    newZoomIndex = zoomUpps.length - 1;
                }
            }
            newZoomIndex = newZoomIndex + zoomInInt;
            navigatorPanel.setUpp(zoomUpps[Math.min(zoomUpps.length - 1, Math.max(0, newZoomIndex))], pixel);
        }
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        this.mouseDown = null;
        if (this.upCursor != null) {
            this.getNavigatorPanel().setCursor(this.upCursor);
        }
    }

    public static void setZoomUpps(double[] zoomUpps) {
        NavigatorPanningAction.zoomUpps = zoomUpps;
    }

    @Override
    protected void mouseMoved(int x, int y) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

