/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.ktde.math.MathHelper;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.swing.ToggleGroup;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.MouseManipulator;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.swing.navigator.NavigatorPanningKeyListener;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.NavigatorRotateAction;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public class NavigatorPanel
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = -4209504084014392908L;
    public static final boolean HEADLESS = StringUtil.isTrue(System.getProperty("java.awt.headless"));
    private Point2D.Double realBoundaryBottomLeft;
    private Point2D.Double realBoundaryTopRight;
    private Dimension pixelDimension;
    private AffineTransform transform;
    private List<NavigatorRenderer> renderers;
    private Object lock = new Object();
    private NavigatorPanningAction panningAction;
    private NavigatorRotateAction rotateAction;
    private MouseManipulator manipulator;
    private MouseManipulator manipulator2;
    private List<MouseManipulator> preferredManipulatorChainForClick = new LinkedList<MouseManipulator>();
    private NavigatorPanningKeyListener keyListener;
    private ToggleGroup toggleActions;
    private final CoordinateFactory coordinateFactory;
    private int buttonActive = 0;
    private String panningActionTitle;
    private boolean isPainting = false;
    private boolean closed = false;

    public NavigatorPanel(Container parentContainer) {
        this(0.0, 0.0, "Panning", parentContainer);
    }

    public NavigatorPanel(String panningActionTitle, Container parentContainer) {
        this(0.0, 0.0, panningActionTitle, parentContainer);
    }

    public NavigatorPanel(double x, double y, Container parentContainer) {
        this(x, y, "Panning", parentContainer);
    }

    public NavigatorPanel(double x, double y, String panningActionTitle, Container parentContainer) {
        this(x, y, MercatorFactory.INSTANCE, panningActionTitle, parentContainer);
    }

    public NavigatorPanel(Coordinate c, Container parentContainer) {
        this(c, c.getFactory(), parentContainer);
    }

    public NavigatorPanel(Coordinate c, String panningActionTitle, Container parentContainer) {
        this(c, c.getFactory(), panningActionTitle, parentContainer);
    }

    public NavigatorPanel(double x, double y, CoordinateFactory coordinateFactory, Container parentContainer) {
        this(coordinateFactory.createCoordinate(x, y), parentContainer);
    }

    public NavigatorPanel(double x, double y, CoordinateFactory coordinateFactory, String panningActionTitle, Container parentContainer) {
        this(coordinateFactory.createCoordinate(x, y), panningActionTitle, parentContainer);
    }

    public NavigatorPanel(Coordinate c, CoordinateFactory coordinateFactory, Container parentContainer) {
        this(c, coordinateFactory, "Panning", parentContainer);
    }

    public NavigatorPanel(Coordinate c, CoordinateFactory coordinateFactory, String panningActionTitle, Container parentContainer) {
        this.panningActionTitle = panningActionTitle;
        Coordinate myC = c == null ? null : coordinateFactory.createCoordinate(c);
        double refScale = 1.0 / coordinateFactory.getRefScale();
        this.transform = AffineTransform.getScaleInstance(refScale, -refScale);
        if (myC != null) {
            this.transform.translate(-myC.getX(), -myC.getY());
        }
        this.renderers = new ArrayList<NavigatorRenderer>();
        this.coordinateFactory = coordinateFactory;
        if (!HEADLESS) {
            this.manipulator2 = new NavigatorPanningAction(panningActionTitle, this, false);
        }
        this.keyListener = new NavigatorPanningKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListenerToContainer(parentContainer);
    }

    public void addKeyListenerToContainer(final Container parentContainer) {
        if (parentContainer != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    parentContainer.addKeyListener(NavigatorPanel.this.getNavigatorPanningKeyListener());
                    this.addKeyListenerRec(parentContainer);
                }

                private void addKeyListenerRec(Container parentContainer2) {
                    for (int i = 0; i < parentContainer2.getComponentCount(); ++i) {
                        Component component = parentContainer2.getComponent(i);
                        if (!(component instanceof JTextComponent)) {
                            component.addKeyListener(NavigatorPanel.this.getNavigatorPanningKeyListener());
                        }
                        if (!(component instanceof Container)) continue;
                        this.addKeyListenerRec((Container)component);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(double translateX, double translateY) {
        AffineTransform affineTransform = this.transform;
        synchronized (affineTransform) {
            AffineTransform translate = AffineTransform.getTranslateInstance(translateX, translateY);
            this.transform.preConcatenate(translate);
            this.pixelDimension = null;
        }
        this.repaint(10L);
    }

    public CoordinateFactory getCoordinateFactory() {
        return this.coordinateFactory;
    }

    public void setMouseManipulator(MouseManipulator manipulator) {
        this.manipulator = manipulator;
    }

    public void setMouseManipulator2(MouseManipulator manipulator2) {
        this.manipulator2 = manipulator2;
    }

    public void addPreferredMouseManipulatorForClick(MouseManipulator manipulator) {
        this.preferredManipulatorChainForClick.add(manipulator);
    }

    public boolean unsetMouseManipulator(MouseManipulator manipulator) {
        if (this.manipulator == manipulator) {
            this.manipulator = null;
            return true;
        }
        return false;
    }

    public MouseManipulator getMouseManipulator() {
        return this.manipulator;
    }

    public void setPanning(boolean on) {
        NavigatorPanningAction manipulator = this.getPanningAction();
        if (manipulator != null) {
            manipulator.setSelected(on);
        }
    }

    public void setRotating(boolean on) {
        NavigatorRotateAction manipulator = this.getRotateAction();
        manipulator.setSelected(on);
    }

    public Point2D.Double getRealBoundaryBottomLeft() {
        return this.realBoundaryBottomLeft;
    }

    public Point2D.Double getRealBoundaryTopRight() {
        return this.realBoundaryTopRight;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
        this.pixelDimension = null;
        this.repaint(10L);
    }

    public Point2D.Double getReal(Point2D pixel) {
        return this.getReal(pixel, null);
    }

    public void forceCalcTransform() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.pixelDimension == null || this.pixelDimension.width != width || this.pixelDimension.height != height) {
            if (this.pixelDimension == null) {
                this.pixelDimension = new Dimension(width, height);
            } else {
                this.pixelDimension.width = width;
                this.pixelDimension.height = height;
            }
            Point2D.Double[] points = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, height), new Point2D.Double(width, 0.0), new Point2D.Double(width, height)};
            Point2D.Double p = new Point2D.Double(0.0, 0.0);
            double maxx = -1.7976931348623157E308;
            double minx = Double.MAX_VALUE;
            double maxy = -1.7976931348623157E308;
            double miny = Double.MAX_VALUE;
            for (Point2D.Double point : points) {
                this.getReal(point, p);
                double x = p.getX();
                double y = p.getY();
                maxx = Math.max(maxx, x);
                minx = Math.min(minx, x);
                maxy = Math.max(maxy, y);
                miny = Math.min(miny, y);
            }
            this.realBoundaryBottomLeft = new Point2D.Double(minx, miny);
            this.realBoundaryTopRight = new Point2D.Double(maxx, maxy);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension size;
        if (this.closed) {
            g.dispose();
        } else if (!this.isPainting && (size = this.getSize()) != null && size.getWidth() > 0.0 && size.getHeight() > 0.0) {
            this.isPainting = true;
            super.paintComponent(g);
            this.forceCalcTransform();
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform saveTransform = g2d.getTransform();
            g2d.transform(this.transform);
            double upp = this.getUpp();
            ArrayList<NavigatorRenderer> rendererClone = new ArrayList<NavigatorRenderer>(this.renderers);
            for (NavigatorRenderer renderer : rendererClone) {
                if (!renderer.isActive()) continue;
                renderer.prepare(this.realBoundaryBottomLeft, this.realBoundaryTopRight, upp);
            }
            Collections.sort(rendererClone, new Comparator<NavigatorRenderer>(){

                @Override
                public int compare(NavigatorRenderer o1, NavigatorRenderer o2) {
                    return o1.getSortOrder() - o2.getSortOrder();
                }
            });
            LinkedList<OnTopRendering> onTops = new LinkedList<OnTopRendering>();
            for (NavigatorRenderer renderer : rendererClone) {
                if (!renderer.isActive()) continue;
                Collection<OnTopRendering> sOnTops = renderer.paintOnto(g2d, this.realBoundaryBottomLeft, this.realBoundaryTopRight, upp);
                onTops.addAll(sOnTops);
            }
            for (OnTopRendering onTopRendering : onTops) {
                onTopRendering.paint();
            }
            g2d.setTransform(saveTransform);
            this.isPainting = false;
        }
    }

    public Point2D.Double getReal(double x, double y) {
        return this.getReal(new Point2D.Double(x, y));
    }

    public Point2D.Double getReal(Point2D pixel, Point2D.Double result) {
        if (result == null) {
            result = new Point2D.Double();
        }
        try {
            this.transform.inverseTransform(pixel, result);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Point2D.Double getPixel(Point2D.Double real) {
        return this.getPixel(real, null);
    }

    public Point2D.Double getPixel(Coordinate real) {
        Coordinate cCorrect = this.coordinateFactory.createCoordinate(real);
        return this.getPixel(new Point2D.Double(cCorrect.getX(), cCorrect.getY()), null);
    }

    public Point2D.Double getPixel(Point2D.Double real, Point2D.Double result) {
        if (result == null) {
            result = new Point2D.Double();
        }
        this.transform.transform(real, result);
        return result;
    }

    public Point2D.Double getCenterPixel() {
        return new Point2D.Double(this.getWidth() / 2, this.getHeight() / 2);
    }

    public double getUpp() {
        double fcosp = this.transform.getScaleX();
        double fsinp = -this.transform.getShearX();
        double f = Math.sqrt(Math.pow(fcosp, 2.0) + Math.pow(fsinp, 2.0));
        double upp = 1.0 / f;
        return upp;
    }

    public void setUpp(double upp) {
        this.setUpp(upp, this.getCenterPixel());
    }

    public void setUpp(double upp, Point2D.Double pixel) {
        double currentUpp = this.getUpp();
        this.zoom(currentUpp / upp, pixel);
    }

    public void addRenderer(NavigatorRenderer renderer) {
        this.renderers.add(renderer);
        if (renderer instanceof AbstractNavigatorRenderer) {
            ((AbstractNavigatorRenderer)renderer).setPanel(this);
        }
        this.repaint(10L);
    }

    public void removeRenderer(NavigatorRenderer renderer) {
        if (this.renderers != null) {
            this.renderers.remove(renderer);
            this.repaint(10L);
        }
    }

    public void zoom(double zoom, Point2D.Double pixel) {
        Point2D.Double real = this.getReal(pixel);
        this.transform.scale(zoom, zoom);
        this.correctTranslation(pixel, real);
    }

    public void rotate(double rotate, Point2D.Double pixel) {
        Point2D.Double real = this.getReal(pixel);
        this.transform.preConcatenate(AffineTransform.getRotateInstance(rotate));
        this.correctTranslation(pixel, real);
    }

    public void flipX(Point2D.Double pixel) {
        Point2D.Double real = this.getReal(pixel);
        this.transform.scale(-1.0, 1.0);
        this.correctTranslation(pixel, real);
    }

    public void flipY(Point2D.Double pixel) {
        Point2D.Double real = this.getReal(pixel);
        this.transform.scale(1.0, -1.0);
        this.correctTranslation(pixel, real);
    }

    public void zoom(double zoom) {
        this.zoom(zoom, this.getCenterPixel());
    }

    public void rotate(double rotate) {
        this.rotate(rotate, this.getCenterPixel());
    }

    public void flipX() {
        this.flipX(this.getCenterPixel());
    }

    public void flipY() {
        this.flipY(this.getCenterPixel());
    }

    private void correctTranslation(Point2D.Double pixel, Point2D.Double real) {
        Point2D.Double curPixel = this.getPixel(real);
        double deltaX = pixel.x - curPixel.x;
        double deltaY = pixel.y - curPixel.y;
        this.translate(deltaX, deltaY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToggleGroup getToggleActions() {
        Object object = this.lock;
        synchronized (object) {
            if (this.toggleActions == null) {
                this.toggleActions = new ToggleGroup();
            }
        }
        return this.toggleActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigatorPanningAction getPanningAction() {
        Object object = this.lock;
        synchronized (object) {
            if (this.panningAction == null && !HEADLESS) {
                this.panningAction = new NavigatorPanningAction(this.panningActionTitle, this);
                this.getToggleActions().addAction(this.panningAction);
            }
        }
        return this.panningAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigatorRotateAction getRotateAction() {
        Object object = this.lock;
        synchronized (object) {
            if (this.rotateAction == null) {
                this.rotateAction = new NavigatorRotateAction(this);
                this.getToggleActions().addAction(this.rotateAction);
            }
        }
        return this.rotateAction;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.buttonActive == 0) {
            for (MouseManipulator mouseManipulator : this.preferredManipulatorChainForClick) {
                if (e.isConsumed()) continue;
                mouseManipulator.mouseClicked(e);
            }
            if (!e.isConsumed()) {
                if (e.getButton() == 1) {
                    if (this.manipulator != null) {
                        this.manipulator.mouseClicked(e);
                    }
                } else if (e.getButton() == 3 && this.manipulator2 != null) {
                    this.manipulator2.mouseClicked(e);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseEntered(e);
        }
        if (this.manipulator2 != null) {
            this.manipulator2.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseExited(e);
        }
        if (this.manipulator2 != null) {
            this.manipulator2.mouseExited(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.buttonActive == 0) {
            for (MouseManipulator mouseManipulator : this.preferredManipulatorChainForClick) {
                if (e.isConsumed()) continue;
                mouseManipulator.mousePressed(e);
            }
            if (!e.isConsumed()) {
                int button = e.getButton();
                if (button == 1 || button == 2) {
                    this.buttonActive = button;
                    if (this.manipulator != null) {
                        this.manipulator.mousePressed(e);
                    }
                } else if (button == 3) {
                    this.buttonActive = 3;
                    if (this.manipulator2 != null) {
                        this.manipulator2.mousePressed(e);
                    }
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.buttonActive == e.getButton()) {
            for (MouseManipulator mouseManipulator : this.preferredManipulatorChainForClick) {
                if (e.isConsumed()) continue;
                mouseManipulator.mouseReleased(e);
            }
            if (!e.isConsumed()) {
                if (this.buttonActive == 1) {
                    if (this.manipulator != null) {
                        this.manipulator.mouseReleased(e);
                    }
                } else if (this.manipulator2 != null) {
                    this.manipulator2.mouseReleased(e);
                }
            }
            this.buttonActive = 0;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.buttonActive == 1) {
            if (this.manipulator != null) {
                this.manipulator.mouseDragged(e);
            }
        } else if (this.manipulator2 != null) {
            this.manipulator2.mouseDragged(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseMoved(e);
        }
        if (this.manipulator2 != null) {
            this.manipulator2.mouseMoved(e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseWheelMoved(e);
        }
    }

    public synchronized void gotoCoordinate(Coordinate c) {
        Coordinate transformed = this.coordinateFactory.createCoordinate(c);
        if (this.pixelDimension != null) {
            Point2D.Double real = new Point2D.Double(transformed.getX(), transformed.getY());
            Point2D.Double pixel = new Point2D.Double((double)this.pixelDimension.width / 2.0, (double)this.pixelDimension.height / 2.0);
            this.correctTranslation(pixel, real);
        }
    }

    public double getScaledUpp() {
        return this.getUpp() / this.coordinateFactory.getRefScale();
    }

    public void center(Coordinate coord) {
        Coordinate transformed = this.getCoordinateFactory().createCoordinate(coord);
        Point2D.Double newCenterPixel = this.getPixel(new Point2D.Double(transformed.getX(), transformed.getY()));
        Point2D.Double currentCenterPixel = this.getCenterPixel();
        this.translate(currentCenterPixel.x - newCenterPixel.x, currentCenterPixel.y - newCenterPixel.y);
    }

    public void center(Collection<Coordinate> coordinates, double percBuffer, boolean allowNonSquareValues) {
        Tripel<Coordinate, Double, Double> tripel = this.getAdaptedCenter(coordinates);
        this.center(tripel.getElement1());
        double width2 = this.getWidth();
        Double width = tripel.getElement2();
        double facX = width2 / (width == 0.0 ? 1.0 : width);
        double height2 = this.getHeight();
        Double height = tripel.getElement3();
        double facY = height2 / (height == 0.0 ? 1.0 : height);
        double zoom = this.transform.getScaleX();
        double newZoom = Math.min(facX, facY) * (100.0 - percBuffer) / 100.0;
        if (!allowNonSquareValues) {
            double two = Math.log(newZoom) / Math.log(2.0);
            double floor = Math.floor(two);
            newZoom = Math.pow(2.0, floor);
        }
        this.zoom(newZoom /= zoom);
        double upp = this.getUpp();
        if (upp <= 0.0) {
            this.setUpp(1.0);
        }
    }

    public void center(Collection<Coordinate> coordinates, int percBuffer) {
        this.center(coordinates, percBuffer, false);
    }

    private Tripel<Coordinate, Double, Double> getAdaptedCenter(Collection<Coordinate> coordinates) {
        if (coordinates == null || coordinates.isEmpty()) {
            Point2D.Double realCenter = this.getReal(this.getCenterPixel());
            return new Tripel<Coordinate, Double, Double>(this.coordinateFactory.createCoordinate(realCenter), 1.0, 1.0);
        }
        if (coordinates.size() == 1) {
            return new Tripel<Coordinate, Double, Double>((Coordinate)coordinates.toArray()[0], 1.0, 1.0);
        }
        Iterator<Coordinate> coordinatesIter = coordinates.iterator();
        Coordinate firstCoordinate = this.coordinateFactory.createCoordinate(coordinatesIter.next());
        double minX = firstCoordinate.getX();
        double maxX = firstCoordinate.getX();
        double minY = firstCoordinate.getY();
        double maxY = firstCoordinate.getY();
        while (coordinatesIter.hasNext()) {
            Coordinate coordinate = this.coordinateFactory.createCoordinate(coordinatesIter.next());
            if (this.isNullCoordinate(coordinate)) continue;
            minX = Math.min(minX, coordinate.getX());
            maxX = Math.max(maxX, coordinate.getX());
            minY = Math.min(minY, coordinate.getY());
            maxY = Math.max(maxY, coordinate.getY());
        }
        Coordinate center = this.coordinateFactory.createCoordinate((minX + maxX) / 2.0, (minY + maxY) / 2.0);
        return new Tripel<Coordinate, Double, Double>(center, maxX - minX, maxY - minY);
    }

    private boolean isNullCoordinate(Coordinate coordinate) {
        GeoDecimal100Factory factory;
        Coordinate transformed;
        boolean b = true;
        if (coordinate != null && MathHelper.between((transformed = (factory = GeoDecimal100Factory.INSTANCE).createCoordinate(coordinate)).getX(), -180.0 * factory.getFactor(), 180.0 * factory.getFactor()) && MathHelper.between(transformed.getY(), -90.0 * factory.getFactor(), 90.0 * factory.getFactor()) && !MathHelper.between(transformed.getX(), -1.0, 1.0) && !MathHelper.between(transformed.getY(), -1.0, 1.0)) {
            b = false;
        }
        return b;
    }

    public Image paintImage() throws InterruptedException {
        Rectangle rectangle = this.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
        Graphics graphics = bufferedImage.getGraphics();
        super.paint(graphics);
        graphics.dispose();
        return bufferedImage;
    }

    public List<NavigatorRenderer> getRenderers() {
        return this.renderers;
    }

    public void addAllRenderer(Collection<NavigatorRenderer> renderers) {
        for (NavigatorRenderer renderer : renderers) {
            this.addRenderer(renderer);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.keyListener != null) {
            this.keyListener.keyPressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.keyListener != null) {
            this.keyListener.keyReleased(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.keyListener != null) {
            this.keyListener.keyTyped(e);
        }
    }

    public NavigatorPanningKeyListener getNavigatorPanningKeyListener() {
        return this.keyListener;
    }

    public void setRenderers(List<NavigatorRenderer> renderers) {
        this.renderers = renderers;
    }

    public void close() {
        this.closed = true;
        if (this.renderers != null) {
            for (NavigatorRenderer navigatorRenderer : this.renderers) {
                navigatorRenderer.close();
                navigatorRenderer.setNavigatorPanel(null);
            }
        }
        this.renderers = null;
        this.realBoundaryBottomLeft = null;
        this.realBoundaryTopRight = null;
        this.pixelDimension = null;
        this.transform = null;
        this.lock = null;
        this.panningAction = null;
        this.rotateAction = null;
        this.manipulator = null;
        this.manipulator2 = null;
        this.preferredManipulatorChainForClick = null;
        this.keyListener = null;
        this.toggleActions = null;
        this.repaint(1L);
    }
}

