/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.ExplodableNavigatorListener;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.SimpleNavigatorFrame;

public class ExplodableNavigatorFrame
extends SimpleNavigatorFrame {
    private static final long serialVersionUID = 3526709693449222848L;
    private JSlider explodeLevelSlider;
    private List<ExplodableNavigatorListener> explodeListeners = new LinkedList<ExplodableNavigatorListener>();

    public ExplodableNavigatorFrame(Dialog owner, boolean modal, CoordinateFactory coordinateFactory, Coordinate startCoords, NavigatorRenderer ... renderer) {
        super(owner, modal, coordinateFactory, startCoords, renderer);
        this.addListeners(renderer);
    }

    public ExplodableNavigatorFrame(Dialog owner, String title, boolean modal, CoordinateFactory coordinateFactory, Coordinate startCoords, NavigatorRenderer ... renderer) {
        super(owner, title, modal, coordinateFactory, startCoords, renderer);
        this.addListeners(renderer);
    }

    public ExplodableNavigatorFrame(Frame owner, boolean modal, CoordinateFactory coordinateFactory, Coordinate startCoords, NavigatorRenderer ... renderer) {
        super(owner, modal, coordinateFactory, startCoords, renderer);
        this.addListeners(renderer);
    }

    public ExplodableNavigatorFrame(Frame owner, String title, boolean modal, CoordinateFactory coordinateFactory, Coordinate startCoords, NavigatorRenderer ... renderer) {
        super(owner, title, modal, coordinateFactory, startCoords, renderer);
        this.addListeners(renderer);
    }

    private void addListeners(NavigatorRenderer ... renderer) {
        for (NavigatorRenderer navigatorRenderer : renderer) {
            if (!(navigatorRenderer instanceof ExplodableNavigatorListener)) continue;
            this.explodeListeners.add((ExplodableNavigatorListener)((Object)navigatorRenderer));
        }
    }

    @Override
    protected void addExtraWidgets() {
        super.addExtraWidgets();
        this.explodeLevelSlider = new JSlider();
        this.explodeLevelSlider.setBorder(BorderFactory.createTitledBorder("Explode level"));
        this.explodeLevelSlider.setMinimum(0);
        this.explodeLevelSlider.setMaximum(100);
        this.explodeLevelSlider.setMajorTickSpacing(20);
        this.explodeLevelSlider.setMinorTickSpacing(5);
        this.explodeLevelSlider.setPaintTicks(true);
        this.explodeLevelSlider.setPaintLabels(true);
        Dimension maximumSize = new Dimension(1024, 40);
        this.explodeLevelSlider.setMaximumSize(maximumSize);
        this.explodeLevelSlider.setValue(0);
        this.explodeLevelSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int level = ExplodableNavigatorFrame.this.explodeLevelSlider.getValue();
                System.out.println(level);
                for (ExplodableNavigatorListener listener : ExplodableNavigatorFrame.this.explodeListeners) {
                    listener.setExplodeLevel(level);
                }
            }
        });
        this.getContentPane().add((Component)this.explodeLevelSlider, "South");
    }
}

