/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.util.ArrayList;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public abstract class AbstractNavigatorRenderer
implements NavigatorRenderer {
    private NavigatorPanel panel;
    private boolean active = true;
    private String name;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private int sortOrder = 0;

    public AbstractNavigatorRenderer(String name) {
        this.name = name;
    }

    protected void setPanel(NavigatorPanel panel) {
        this.panel = panel;
    }

    public NavigatorPanel getPanel() {
        return this.panel;
    }

    public CoordinateFactory getCoordinateFactory() {
        return this.panel.getCoordinateFactory();
    }

    public void callRepaint() {
        this.callRepaint(10L);
    }

    public void callRepaint(Long milliseconds) {
        if (this.panel != null) {
            this.panel.repaint(milliseconds);
        }
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.callRepaint();
            this.fireActiveChanged();
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.setPanel(navigatorPanel);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    protected void fireActiveChanged() {
        NavigatorRendererActivateEvent navigatorPanelActivateEvent = new NavigatorRendererActivateEvent(this, this.isActive());
        for (NavigatorRendererActiveListener navigatorPanelActiveListener : this.navigatorPanelActiveListeners) {
            navigatorPanelActiveListener.valueChanged(navigatorPanelActivateEvent);
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.getName();
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

