/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.graphics;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class TurtleString {
    private static Map<Character, Double[][]> charways;

    private static void initWays() {
        charways = new HashMap<Character, Double[][]>();
        charways.put(Character.valueOf('0'), new Double[][]{{0.2, 0.9, 0.5, 0.9, 0.6, 0.8, 0.6, 0.1, 0.5, 0.0, 0.2, 0.0, 0.1, 0.1, 0.1, 0.8, 0.2, 0.9}});
        charways.put(Character.valueOf('1'), new Double[][]{{0.35, 0.9, 0.35, 0.0, 0.2, 0.15}});
        charways.put(Character.valueOf('2'), new Double[][]{{0.1, 0.1, 0.2, 0.0, 0.5, 0.0, 0.6, 0.1, 0.6, 0.3, 0.2, 0.6, 0.1, 0.9, 0.6, 0.9}});
        charways.put(Character.valueOf('3'), new Double[][]{{0.1, 0.1, 0.2, 0.0, 0.5, 0.0, 0.6, 0.1, 0.6, 0.3, 0.5, 0.4, 0.3, 0.4}, {0.5, 0.4, 0.6, 0.5, 0.6, 0.8, 0.5, 0.9, 0.2, 0.9, 0.1, 0.8}});
        charways.put(Character.valueOf('4'), new Double[][]{{0.5, 0.9, 0.5, 0.0, 0.1, 0.7, 0.6, 0.7}});
        charways.put(Character.valueOf('5'), new Double[][]{{0.1, 0.8, 0.2, 0.9, 0.5, 0.9, 0.6, 0.8, 0.6, 0.5, 0.5, 0.4, 0.1, 0.4, 0.1, 0.0, 0.6, 0.0}});
        charways.put(Character.valueOf('6'), new Double[][]{{0.1, 0.1, 0.2, 0.0, 0.5, 0.0, 0.6, 0.1}, {0.5, 0.4, 0.1, 0.4}, {0.5, 0.4, 0.6, 0.5, 0.6, 0.8, 0.5, 0.9, 0.2, 0.9, 0.1, 0.8, 0.1, 0.2}});
        charways.put(Character.valueOf('7'), new Double[][]{{0.1, 0.1, 0.1, 0.0, 0.6, 0.0, 0.6, 0.3, 0.4, 0.5, 0.3, 0.7, 0.3, 0.9}});
        charways.put(Character.valueOf('8'), new Double[][]{{0.1, 0.1, 0.2, 0.0, 0.5, 0.0, 0.6, 0.1, 0.6, 0.3, 0.5, 0.4, 0.2, 0.4}, {0.5, 0.4, 0.6, 0.5, 0.6, 0.8, 0.5, 0.9, 0.2, 0.9, 0.1, 0.8, 0.1, 0.5, 0.2, 0.4, 0.1, 0.3, 0.1, 0.2}});
        charways.put(Character.valueOf('9'), new Double[][]{{0.1, 0.1, 0.2, 0.0, 0.5, 0.0, 0.6, 0.1, 0.6, 0.4, 0.2, 0.4}, {0.6, 0.4, 0.6, 0.8, 0.5, 0.9, 0.2, 0.9, 0.1, 0.8}, {0.2, 0.4, 0.1, 0.3, 0.1, 0.2}});
    }

    public double width(char c) {
        return 0.7;
    }

    public void render(Graphics2D g2d, String string, double size, Point2D basePoint, boolean inverseY) {
        double x = basePoint.getX();
        double y = basePoint.getY();
        double iy = inverseY ? -1.0 : 1.0;
        for (char c : string.toCharArray()) {
            this.render(g2d, c, size, x, y, iy);
            x += this.width(c) * size;
        }
    }

    public void render(Graphics2D g2d, char c, double size, double x, double y, double iy) {
        TurtleString.initWays();
        Double[][] ways = charways.get(Character.valueOf(c));
        if (ways != null) {
            GeneralPath p = new GeneralPath();
            for (Double[] doubles : ways) {
                ((Path2D)p).moveTo(x + doubles[0] * size, y + doubles[1] * size * iy);
                for (int i = 2; i < doubles.length; i += 2) {
                    ((Path2D)p).lineTo(x + doubles[i] * size, y + doubles[i + 1] * size * iy);
                }
            }
            g2d.draw(p);
        }
    }

    static {
        TurtleString.initWays();
    }
}

