/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.ktde.model.AbstractSaveModelsAction;
import org.ktde.model.SaveModelsAction;
import org.ktde.swing.ModelDrivenUndoableEdit;

public class UndoManager {
    private javax.swing.undo.UndoManager undoManager;
    private Action undoAction;
    private Action redoAction;
    private Action saveAction;
    private SaveModelsAction originalSaveAction;
    private Action revertAction;
    private Stack<UndoableEditEvent> undoStack = new Stack();
    private Stack<UndoableEditEvent> redoStack = new Stack();

    public UndoManager(SaveModelsAction saveAction) {
        this.undoManager = new javax.swing.undo.UndoManager();
        this.undoAction = new AbstractAction(""){
            private static final long serialVersionUID = 7791045530948446136L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UndoManager.this.undo();
                }
                catch (CannotUndoException cre) {
                    cre.printStackTrace();
                }
                UndoManager.this.setEnabledStates();
            }
        };
        this.undoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 128));
        this.redoAction = new AbstractAction(""){
            private static final long serialVersionUID = -3755552903500791456L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UndoManager.this.redo();
                }
                catch (CannotRedoException cre) {
                    cre.printStackTrace();
                }
                UndoManager.this.setEnabledStates();
            }
        };
        this.redoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 128));
        this.revertAction = new AbstractAction(this.getRevertActionName()){
            private static final long serialVersionUID = -7776724353695343606L;

            @Override
            public void actionPerformed(ActionEvent e) {
                while (UndoManager.this.canUndo()) {
                    try {
                        UndoManager.this.undo();
                    }
                    catch (CannotUndoException cre) {
                        cre.printStackTrace();
                    }
                }
                if (UndoManager.this.saveAction != null) {
                    UndoManager.this.originalSaveAction.clear();
                }
                UndoManager.this.setEnabledStates();
            }
        };
        this.revertAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 640));
        this.setSaveAction(saveAction);
    }

    protected String getRevertActionName() {
        return "Revert all";
    }

    public synchronized void pushUndoEvent(UndoableEditEvent e) {
        this.undoStack.push(e);
        this.redoStack.clear();
        this.undoManager.undoableEditHappened(e);
        UndoableEdit edit = e.getEdit();
        if (edit instanceof ModelDrivenUndoableEdit) {
            this.originalSaveAction.enqueueModel(((ModelDrivenUndoableEdit)edit).getModel());
        }
        this.setEnabledStates();
    }

    private void setEnabledStates() {
        boolean canUndo = this.undoManager.canUndo();
        boolean canRedo = this.undoManager.canRedo();
        this.undoAction.setEnabled(canUndo);
        this.redoAction.setEnabled(canRedo);
        if (this.saveAction != null) {
            this.saveAction.setEnabled(canUndo);
        }
        if (this.revertAction != null) {
            this.revertAction.setEnabled(canUndo);
        }
        this.undoAction.putValue("Name", this.getUndoActionName(canUndo));
        this.redoAction.putValue("Name", this.getRedoActionName(canRedo));
    }

    protected String getUndoActionName(boolean canUndo) {
        return "Undo: " + (canUndo ? this.getUndoPresentationName() : "N/A");
    }

    protected String getUndoPresentationName() {
        return this.undoManager.getUndoPresentationName();
    }

    protected String getRedoActionName(boolean canRedo) {
        return "Redo: " + (canRedo ? this.getRedoPresentationName() : "N/A");
    }

    protected String getRedoPresentationName() {
        return this.undoManager.getRedoPresentationName();
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getRevertAction() {
        return this.revertAction;
    }

    public Action getSaveAction() {
        return this.saveAction;
    }

    public void setSaveAction(final SaveModelsAction saveAction) {
        if (saveAction != null) {
            this.originalSaveAction = saveAction;
            this.saveAction = saveAction instanceof AbstractSaveModelsAction ? new AbstractSaveModelsAction((String)saveAction.getValue("Name")){
                private static final long serialVersionUID = -3987037815677340130L;

                @Override
                public boolean performSave() {
                    if (((AbstractSaveModelsAction)saveAction).performSave()) {
                        ((AbstractSaveModelsAction)saveAction).clear();
                        UndoManager.this.undoManager.discardAllEdits();
                        UndoManager.this.setEnabledStates();
                        return true;
                    }
                    return false;
                }
            } : new AbstractSaveModelsAction((String)saveAction.getValue("Name")){
                private static final long serialVersionUID = -3255620625011069433L;

                @Override
                public boolean performSave() {
                    saveAction.actionPerformed(null);
                    saveAction.clear();
                    UndoManager.this.undoManager.discardAllEdits();
                    UndoManager.this.setEnabledStates();
                    return true;
                }
            };
            this.saveAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
        } else {
            this.saveAction = null;
        }
        this.setEnabledStates();
    }

    protected synchronized void undo() {
        this.redoStack.push(this.undoStack.pop());
        this.undoManager.undo();
    }

    protected synchronized void undoWithoutRedo() {
        this.undoManager.undo();
    }

    protected synchronized void redo() {
        this.undoStack.push(this.redoStack.pop());
        this.undoManager.redo();
    }

    public List<UndoableEditEvent> getCurrentUndoEvents() {
        LinkedList<UndoableEditEvent> result = new LinkedList<UndoableEditEvent>();
        result.addAll(this.undoStack);
        return result;
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public boolean canUndoOrRedo() {
        return this.undoManager.canUndoOrRedo();
    }

    public synchronized void clear() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.undoManager.discardAllEdits();
        this.setEnabledStates();
    }

    public void joinTransaction() {
    }

    public void startTransaction() {
    }

    public void finishTransaction(String name) {
    }

    public void rollbackTransaction() {
    }
}

