/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class ResourceObserver
implements ImageObserver,
Runnable {
    private Thread thread;
    private boolean stopped = false;

    public ResourceObserver(Image i) {
        this(i, -1, -1);
    }

    public ResourceObserver(Image i, int w, int h) {
        if (!Toolkit.getDefaultToolkit().prepareImage(i, w, h, this)) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.stopWaiting();
        return true;
    }

    public void stopWaiting() {
        this.stopped = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void joinThread() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

