/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.model.AbstractDelegatingModel;
import org.ktde.model.Model;
import org.ktde.swing.ObjectTable;
import org.ktde.util.datatypes.Tupel;

public class ObjectTableSelectedRowInvokationHandler<T>
implements InvocationHandler,
ListSelectionListener {
    private final ObjectTable<T> objectTable;
    private final Class<T> delegateClass;
    private T delegate;
    private final Map<String, Tupel<Method, AbstractDelegatingModel>> knownMembers;

    public ObjectTableSelectedRowInvokationHandler(ObjectTable<T> objectTable, Class<T> delegateClass) {
        this.objectTable = objectTable;
        this.delegateClass = delegateClass;
        this.knownMembers = new HashMap<String, Tupel<Method, AbstractDelegatingModel>>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        System.out.println(method);
        System.out.println(Arrays.toString(args));
        String methodname = method.getName();
        boolean getter = false;
        boolean setter = false;
        String member = null;
        if (methodname.equals("equals") || methodname.equals("hashCode")) {
            if (this.delegate == null) {
                if (methodname.equals("hashCode")) {
                    return 0;
                }
                if (methodname.equals("equals")) {
                    return args[0] == null;
                }
            }
        } else if (methodname.startsWith("get")) {
            member = methodname.substring(3);
            getter = true;
        } else if (methodname.startsWith("set")) {
            member = methodname.substring(3);
            setter = true;
        } else if (methodname.startsWith("is")) {
            member = methodname.substring(2);
            getter = true;
        }
        if (getter || setter) {
            AbstractDelegatingModel<Model> model;
            Tupel<Method, AbstractDelegatingModel> tupel = this.knownMembers.get(member);
            if (tupel != null) {
                model = tupel.getElement2();
            } else {
                Method getterMethod = method;
                if (setter) {
                    getterMethod = this.delegateClass.getMethod("get" + member, new Class[0]);
                }
                if (this.delegate == null) {
                    model = AbstractDelegatingModel.createDelegateModel(getterMethod.getReturnType());
                } else {
                    Model memberContent = (Model)getterMethod.invoke(this.delegate, new Object[0]);
                    model = AbstractDelegatingModel.createDelegateModel(memberContent);
                }
                this.knownMembers.put(member, new Tupel<Method, AbstractDelegatingModel<Model>>(getterMethod, model));
            }
            if (getter) {
                return model;
            }
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object newDelegate = null;
        int index = ((ListSelectionModel)e.getSource()).getMinSelectionIndex();
        if (index != -1) {
            newDelegate = this.objectTable.getModelAt(index);
        }
        if (newDelegate != this.delegate) {
            this.delegate = newDelegate;
            boolean isNull = newDelegate == null;
            for (Map.Entry<String, Tupel<Method, AbstractDelegatingModel>> entry : this.knownMembers.entrySet()) {
                Model childDelegate = null;
                try {
                    childDelegate = (Model)(isNull ? null : entry.getValue().getElement1().invoke(newDelegate, new Object[0]));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                entry.getValue().getElement2().setDelegate(childDelegate);
            }
        }
    }
}

