/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.ktde.swing.DefaultTabbedPaneRenderer;
import org.ktde.swing.TabbedPaneRenderer;

public class JTabbedPane
extends javax.swing.JTabbedPane
implements ListDataListener {
    private static final long serialVersionUID = -1877159221623873814L;
    protected ListModel model;
    protected TabbedPaneRenderer renderer;

    public JTabbedPane() {
        this(new DefaultListModel(), new DefaultTabbedPaneRenderer());
    }

    public JTabbedPane(ListModel model) {
        this(model, new DefaultTabbedPaneRenderer());
    }

    public JTabbedPane(ListModel model, TabbedPaneRenderer renderer) {
        this.setRenderer(renderer);
        this.setListModel(model);
    }

    public void setRenderer(TabbedPaneRenderer renderer) {
        this.renderer = renderer;
    }

    public void setListModel(ListModel model) {
        if (model != null) {
            model.removeListDataListener(this);
        }
        this.model = model;
        this.removeAll();
        if (model != null) {
            this.intervalAdded(0, model.getSize() - 1);
            model.addListDataListener(this);
        }
    }

    public ListModel getListModel() {
        return this.model;
    }

    public void setSelectionModel(SingleSelectionModel model) {
        super.setModel(model);
    }

    public SingleSelectionModel getSelectionModel() {
        return super.getModel();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.contentsChanged(Math.min(e.getIndex0(), e.getIndex1()), Math.max(e.getIndex0(), e.getIndex1()));
    }

    private void contentsChanged(int start, int end) {
        end = Math.min(this.model.getSize() - 1, end);
        int cEnd = Math.min(this.getTabCount() - 1, end);
        for (int i = start = Math.max(0, start); i <= cEnd; ++i) {
            Object o = this.model.getElementAt(i);
            super.setTitleAt(i, this.renderer.getTitle(o));
            super.setComponentAt(i, this.renderer.getComponent(o));
        }
        if (cEnd < end) {
            this.intervalAdded(cEnd + 1, end);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.intervalAdded(Math.min(e.getIndex0(), e.getIndex1()), Math.max(e.getIndex0(), e.getIndex1()));
    }

    private void intervalAdded(int start, int end) {
        end = Math.min(this.model.getSize() - 1, end);
        for (int i = start = Math.max(0, start); i <= end; ++i) {
            Object o = this.model.getElementAt(i);
            super.insertTab(this.renderer.getTitle(o), this.renderer.getIcon(o), this.renderer.getComponent(o), this.renderer.getTooltip(o), i);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.intervalRemoved(Math.min(e.getIndex0(), e.getIndex1()), Math.max(e.getIndex0(), e.getIndex1()));
    }

    private void intervalRemoved(int start, int end) {
        end = Math.min(this.getTabCount() - 1, end);
        start = Math.max(0, start);
        for (int i = end; i >= start; --i) {
            super.removeTabAt(i);
        }
    }
}

