/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.model.IntegerModelImpl;
import org.ktde.model.ScalarModel;

public class JSpinField<T extends Number>
extends JPanel
implements ChangeListener,
CaretListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 5099624274845312336L;
    private JSpinner spinner;
    private JTextField textField;
    private T min;
    private T max;
    private ScalarModel<T> model;

    public JSpinField(ScalarModel<T> model, T min, T max) {
        this.model = model;
        this.setName("JSpinField");
        this.min = min;
        this.max = max;
        this.correctMinMax();
        this.setLayout(new BorderLayout());
        this.textField = new JTextField();
        this.textField.addCaretListener(this);
        this.textField.addActionListener(this);
        this.textField.setHorizontalAlignment(4);
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setText(model.toString());
        this.textField.addFocusListener(this);
        this.spinner = new JSpinner(){
            private static final long serialVersionUID = -6287709243342021172L;
            private JTextField textField = new JTextField();

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(size.width, this.textField.getPreferredSize().height);
            }
        };
        this.spinner.setEditor(this.textField);
        this.spinner.addChangeListener(this);
        this.add((Component)this.spinner, "Center");
    }

    private void correctMinMax() {
        Number value = (Number)this.model.getValue();
        if (((Comparable)this.max).compareTo(this.min) < 0) {
            this.max = this.min;
        }
        if (((Comparable)this.max).compareTo(value) < 0) {
            this.model.setValue(this.max);
        } else if (((Comparable)this.min).compareTo(value) > 0) {
            this.model.setValue(this.min);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.spinner.getModel();
        this.setValue(model.getNumber());
    }

    protected void setValue(T newValue) {
        Number oldValue = (Number)this.model.getValue();
        if (((Comparable)this.max).compareTo(newValue) < 0) {
            this.model.setValue(this.max);
        } else if (((Comparable)this.min).compareTo(newValue) > 0) {
            this.model.setValue(this.min);
        } else {
            this.model.setValue(newValue);
        }
        this.textField.setText(this.model.toString());
        this.textField.setForeground(Color.black);
        this.firePropertyChange("value", oldValue, this.model.getValue());
        System.err.println("spinnerup");
        this.spinner.setValue(this.model.getValue());
    }

    public T getValue() {
        return (T)((Number)this.model.getValue());
    }

    public void setMinimum(T newMinimum) {
        this.min = newMinimum;
        this.correctMinMax();
    }

    public T getMinimum() {
        return this.min;
    }

    public void setMaximum(T newMaximum) {
        this.max = newMaximum;
        this.correctMinMax();
    }

    public void setHorizontalAlignment(int alignment) {
        this.textField.setHorizontalAlignment(alignment);
    }

    public T getMaximum() {
        return this.max;
    }

    @Override
    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    @Override
    public void setForeground(Color fg) {
        if (this.textField != null) {
            this.textField.setForeground(fg);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        block6: {
            try {
                Number testValue = (Number)this.model.parseValueFromString(this.textField.getText());
                if (((Comparable)this.max).compareTo(testValue) < 0) {
                    this.textField.setForeground(Color.RED);
                } else if (((Comparable)this.min).compareTo(testValue) > 0) {
                    this.textField.setForeground(Color.RED);
                } else {
                    this.textField.setForeground(Color.BLACK);
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof NumberFormatException)) break block6;
                this.textField.setForeground(Color.RED);
            }
        }
        this.textField.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setValue((Number)this.model.parseValueFromString(this.textField.getText()));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.spinner.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        if (!enabled) {
            this.textField.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
    }

    public Component getSpinner() {
        return this.spinner;
    }

    public static void main(String[] s) {
        final IntegerModelImpl model1 = new IntegerModelImpl();
        final IntegerModelImpl model2 = new IntegerModelImpl();
        JFrame frame = new JFrame("JSpinField");
        frame.getContentPane().setLayout(new GridLayout(2, 1));
        frame.getContentPane().add(new JSpinField<Integer>(model1, 0, Integer.MAX_VALUE));
        frame.getContentPane().add(new JSpinField<Integer>(model2, -10, 10));
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                int a = 0;
                int b = 0;
                while (true) {
                    int a2;
                    if ((a2 = ((Integer)model1.getValue()).intValue()) != a) {
                        System.out.println("Set 1 to " + a2);
                    }
                    a = a2;
                    int b2 = (Integer)model2.getValue();
                    if (b2 != b) {
                        System.out.println("Set 2 to " + b2);
                    }
                    b = b2;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.actionPerformed(null);
    }
}

