/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import org.ktde.model.StringModel;
import org.ktde.model.StringModelImpl;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;

public class JSimpleTextField
extends JTextField
implements ValueChangeListener,
FocusListener,
ActionListener,
KeyListener {
    private static final long serialVersionUID = 188229952602963922L;
    private StringModel model;
    private boolean lock;

    public JSimpleTextField() {
        this(new StringModelImpl());
    }

    public JSimpleTextField(String text) {
        this(new StringModelImpl(text));
    }

    public JSimpleTextField(StringModel model) {
        super((String)model.getValue());
        this.addFocusListener(this);
        this.addActionListener(this);
        this.addKeyListener(this);
        this.model = model;
        this.model.addValueChangeListener(this);
    }

    public void setModel(StringModel model) {
        if (model == null) {
            model = new StringModelImpl();
        }
        this.model.removeValueChangeListener(this);
        this.model = model;
        model.addValueChangeListener(this);
        this.setText((String)model.getValue());
    }

    public StringModel getModel() {
        return this.model;
    }

    @Override
    public void valueChanged(ValueChangeEvent e) {
        if (!this.lock) {
            this.lock = true;
            this.setText((String)e.getNewValue());
            this.lock = false;
        }
    }

    public void updateModel() {
        this.model.setValue(this.getText());
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.updateModel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

