/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import org.ktde.model.StringModel;
import org.ktde.model.StringModelImpl;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;

public class JSimpleComboBox
extends JComboBox
implements ValueChangeListener,
ItemListener {
    private static final long serialVersionUID = 8580603756636537661L;
    private StringModel model;
    private boolean lock;

    public JSimpleComboBox(Object[] items) {
        super(items);
        if (items == null || items.length == 0) {
            throw new IllegalArgumentException();
        }
        this.model = new StringModelImpl(items[0].toString());
        this.initialize();
    }

    public JSimpleComboBox(Vector<String> items) {
        super(items);
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.model = new StringModelImpl(items.elementAt(0));
        this.initialize();
    }

    public JSimpleComboBox(List<String> items) {
        this(items.toArray());
    }

    private void initialize() {
        this.addItemListener(this);
        this.model.addValueChangeListener(this);
    }

    public StringModel getStringModel() {
        return this.model;
    }

    @Override
    public void valueChanged(ValueChangeEvent e) {
        if (!this.lock) {
            this.lock = true;
            String nValue = (String)e.getNewValue();
            boolean found = false;
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!this.getItemAt(i).equals(nValue)) continue;
                this.setSelectedIndex(i);
                found = true;
                break;
            }
            if (!found) {
                this.addItem(nValue);
                this.setSelectedIndex(this.getItemCount() - 1);
            }
            this.lock = false;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.model.setValue((String)this.getSelectedItem());
    }
}

