/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.ktde.swing.AbstractDesktopClientActions;
import org.ktde.swing.InternalFrame;
import org.ktde.util.ExceptionHelper;
import org.ktde.util.MultitonManager;
import org.ktde.util.StringUtil;

public abstract class DesktopClientApplication<T extends InternalFrame>
extends JFrame {
    private static final long serialVersionUID = -8127063638304311663L;
    private JDesktopPane desktop;
    protected MultitonManager<Integer, Action> actions;
    private Map<String, T> windows;
    private Integer exitAction;
    private Properties properties;
    protected final JToolBar toolbar;
    protected final JMenuBar menubar;
    protected final JLabel statusbar;

    public DesktopClientApplication(String title, Properties properties, MultitonManager<Integer, Action> desktopClientActions, Integer exitAction) throws Exception {
        super(title);
        String lookandfeel;
        this.properties = properties;
        if (desktopClientActions instanceof AbstractDesktopClientActions) {
            ((AbstractDesktopClientActions)desktopClientActions).setApplication(this);
        }
        if ((lookandfeel = properties.getProperty("lookandfeel")) == null || lookandfeel.equalsIgnoreCase("system")) {
            lookandfeel = UIManager.getSystemLookAndFeelClassName();
        } else if (lookandfeel.equalsIgnoreCase("cross")) {
            lookandfeel = UIManager.getCrossPlatformLookAndFeelClassName();
        }
        UIManager.setLookAndFeel(lookandfeel);
        this.exitAction = exitAction;
        this.windows = new HashMap<String, T>();
        this.desktop = new JDesktopPane();
        this.actions = desktopClientActions;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.desktop, "Center");
        this.statusbar = new JLabel();
        this.getContentPane().add((Component)this.statusbar, "South");
        this.initialize();
        this.toolbar = this.createToolbar();
        if (this.toolbar != null) {
            this.getContentPane().add((Component)this.toolbar, "North");
        }
        this.menubar = this.createMenuBar();
        if (this.menubar != null) {
            this.setJMenuBar(this.menubar);
        }
        String xString = this.properties.getProperty("window.x");
        int x = 0;
        try {
            x = Integer.parseInt(xString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String yString = this.properties.getProperty("window.y");
        int y = 0;
        try {
            y = Integer.parseInt(yString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLocation(x, y);
        String widthString = this.properties.getProperty("window.width");
        int width = 600;
        if (widthString != null && widthString.length() > 0) {
            width = Integer.parseInt(widthString);
        }
        String heightString = this.properties.getProperty("window.height");
        int height = 600;
        if (heightString != null && heightString.length() > 0) {
            height = Integer.parseInt(heightString);
        }
        this.setSize(width, height);
        this.setVisible(true);
    }

    protected void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.actions.getInstance(this.exitAction).actionPerformed(null);
        } else {
            super.processWindowEvent(e);
        }
    }

    protected JToolBar createToolbar() {
        JToolBar toolBar = new JToolBar("Standard Tools");
        return toolBar;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = this.createFileMenu();
        if (fileMenu != null) {
            menuBar.add(fileMenu);
        }
        return menuBar;
    }

    protected JMenu createFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.actions.getInstance(this.exitAction));
        return fileMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWindow(String name) {
        Map<String, T> map = this.windows;
        synchronized (map) {
            return this.windows.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWindow(String id) {
        Map<String, T> map = this.windows;
        synchronized (map) {
            return this.windows.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusWindow(String name) {
        Map<String, T> map = this.windows;
        synchronized (map) {
            final InternalFrame window = (InternalFrame)this.windows.get(name);
            if (window != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (window.isIcon()) {
                            try {
                                window.setIcon(false);
                            }
                            catch (PropertyVetoException e) {
                                e.printStackTrace();
                            }
                        }
                        window.moveToFront();
                        window.grabFocus();
                        try {
                            window.setMaximum(true);
                        }
                        catch (PropertyVetoException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWindow(final String name, T window, InternalFrameListener ... frameListeners) {
        Map<String, T> map = this.windows;
        synchronized (map) {
            for (InternalFrameListener internalFrameListener : frameListeners) {
                ((JInternalFrame)window).addInternalFrameListener(internalFrameListener);
            }
            this.desktop.add((Component)window);
            ((JInternalFrame)window).addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    DesktopClientApplication.this.closeWindow(name);
                }
            });
            ((JComponent)window).setVisible(true);
            this.windows.put(name, window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWindow(String name) {
        Map<String, T> map = this.windows;
        synchronized (map) {
            final InternalFrame window = (InternalFrame)this.windows.get(name);
            if (window != null && window.close()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DesktopClientApplication.this.dispose(window);
                    }
                });
                this.windows.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeAllWindows() {
        Map<String, T> map = this.windows;
        synchronized (map) {
            for (final InternalFrame window : this.windows.values()) {
                if (window.close()) continue;
                return false;
            }
            for (final InternalFrame window : this.windows.values()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DesktopClientApplication.this.dispose(window);
                    }
                });
            }
            this.windows.clear();
        }
        return true;
    }

    public Map<String, T> getAllWindows() {
        return Collections.unmodifiableMap(this.windows);
    }

    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public void showMessage(Exception exception) {
        String stacktrace;
        try {
            stacktrace = ExceptionHelper.getStackTrace(exception);
        }
        catch (Exception ex) {
            stacktrace = exception.getMessage();
        }
        JTextArea textArea = new JTextArea(stacktrace, 10, 50);
        textArea.setEditable(false);
        JOptionPane.showMessageDialog(this, new JScrollPane(textArea), "Fehler", 0);
    }

    public int showMessage(String message, int options) {
        return JOptionPane.showConfirmDialog(this, message, null, options);
    }

    public int showMessage(Component message, int options) {
        return JOptionPane.showConfirmDialog(this, message, null, options);
    }

    public Object getManagementBo() {
        return null;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public abstract Action getAction(String var1);

    public abstract void dispatchApplicationMessage(Object var1);

    protected void initialize() {
    }

    public void setStatus(String text) {
        text = StringUtil.trim(text);
        this.statusbar.setText(text);
    }

    public void putToFront(T t) {
        ((JComponent)t).setVisible(true);
    }

    private void dispose(InternalFrame window) {
        window.dispose();
    }
}

