/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.ktde.swing.ToggleAction;

public abstract class AbstractToggleAction
extends AbstractAction
implements ToggleAction {
    private static final long serialVersionUID = -8365435569761982111L;
    private String titleOn;
    private String titleOff;
    private Icon iconOn;
    private Icon iconOff;
    private boolean on;
    private EventListenerList listenerList;

    public AbstractToggleAction() {
        this("on", "off");
    }

    public AbstractToggleAction(String title, boolean on) {
        this(title, title, null, null, on);
    }

    public AbstractToggleAction(String title) {
        this(title, title, null, null, false);
    }

    public AbstractToggleAction(String titleOn, String titleOff, boolean on) {
        this(titleOn, titleOff, null, null, on);
    }

    public AbstractToggleAction(String titleOn, String titleOff) {
        this(titleOn, titleOff, null, null, false);
    }

    public AbstractToggleAction(Icon icon, boolean on) {
        this(null, null, icon, icon, on);
    }

    public AbstractToggleAction(Icon icon) {
        this(null, null, icon, icon, false);
    }

    public AbstractToggleAction(Icon iconOn, Icon iconOff, boolean on) {
        this(null, null, iconOn, iconOff, on);
    }

    public AbstractToggleAction(Icon iconOn, Icon iconOff) {
        this(null, null, iconOn, iconOff, false);
    }

    public AbstractToggleAction(String title, Icon icon, boolean on) {
        this(title, title, icon, icon, on);
    }

    public AbstractToggleAction(String title, Icon icon) {
        this(title, title, icon, icon, false);
    }

    public AbstractToggleAction(String titleOn, String titleOff, Icon iconOn, Icon iconOff) {
        this(titleOn, titleOff, iconOn, iconOff, false);
    }

    public AbstractToggleAction(String titleOn, String titleOff, Icon iconOn, Icon iconOff, boolean on) {
        this.titleOn = titleOn;
        this.titleOff = titleOff;
        this.iconOn = iconOn;
        this.iconOff = iconOff;
        this.on = on;
        this.listenerList = new EventListenerList();
        this.calcState();
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.listenerList.add(VetoableChangeListener.class, listener);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.listenerList.remove(VetoableChangeListener.class, listener);
    }

    protected void fireVetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != VetoableChangeListener.class) continue;
            ((VetoableChangeListener)listeners[i + 1]).vetoableChange(e);
        }
    }

    private void calcState() {
        if (this.on) {
            this.putValue("Name", this.titleOn);
            this.putValue("SmallIcon", this.iconOn);
        } else {
            this.putValue("Name", this.titleOff);
            this.putValue("SmallIcon", this.iconOff);
        }
        this.putValue("SwingSelectedKey", this.on);
    }

    public Icon iconOff() {
        return this.iconOff;
    }

    public Icon iconOn() {
        return this.iconOn;
    }

    public String titleOff() {
        return this.titleOff;
    }

    public String titleOn() {
        return this.titleOn;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.on != selected) {
            try {
                this.fireVetoableChange(new PropertyChangeEvent(this, "SwingSelectedKey", this.on, selected));
                this.on = selected;
                if (this.on) {
                    this.turnOn();
                } else {
                    this.turnOff();
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.calcState();
        }
    }

    @Override
    public boolean isSelected() {
        return this.on;
    }

    @Override
    public final synchronized void actionPerformed(ActionEvent e) {
        this.setSelected(!this.on);
    }
}

