/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model.collections.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.ktde.model.ScalarModel;
import org.ktde.model.collections.ListModel;
import org.ktde.model.collections.wrapper.CollectionModelWrapper;
import org.ktde.model.collections.wrapper.ModelListIteratorWrapper;

public class ListModelWrapper<T>
extends CollectionModelWrapper<T>
implements List<T> {
    private ListModel<ScalarModel<T>> delegate;
    private ScalarModel<T> prototype;

    public ListModelWrapper(ListModel<ScalarModel<T>> delegate, ScalarModel<T> prototype) {
        super(delegate, prototype);
        this.delegate = delegate;
        this.prototype = prototype;
    }

    @Override
    public void add(int index, T element) {
        this.delegate.add(index, this.prototype.createInstance(element));
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        ArrayList<ScalarModel<T>> conv = new ArrayList<ScalarModel<T>>();
        for (T e : c) {
            conv.add(this.prototype.createInstance(e));
        }
        return this.delegate.addAll(index, conv);
    }

    @Override
    public T get(int index) {
        return ((ScalarModel)this.delegate.get(index)).getValue();
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        for (ScalarModel<T> element : this.delegate) {
            T value = element.getValue();
            if (value == null && o == null || value.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.size() - 1;
        for (ScalarModel<T> element : this.delegate) {
            T value = element.getValue();
            if (value == null && o == null || value.equals(o)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ModelListIteratorWrapper<T>(this.delegate.listIterator(), this.prototype);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ModelListIteratorWrapper<T>(this.delegate.listIterator(index), this.prototype);
    }

    @Override
    public T remove(int index) {
        ScalarModel removed = (ScalarModel)this.delegate.remove(index);
        return removed.getValue();
    }

    @Override
    public T set(int index, T element) {
        ((ScalarModel)this.delegate.get(index)).setValue(element);
        return element;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new ListModelWrapper<T>((ListModel)this.delegate.subList(fromIndex, toIndex), this.prototype);
    }
}

